/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PublicKey;
import java.util.Optional;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicKeyReader.class);

    Optional<PublicKey> fromPEM(Optional<String> pemKey) {
        return pemKey.map(k -> new PEMParser((Reader)new PemReader((Reader)new StringReader((String)k)))).flatMap(this::publicKeyFrom);
    }

    private Optional<PublicKey> publicKeyFrom(PEMParser reader) {
        try {
            Object readPEM = reader.readObject();
            if (readPEM instanceof SubjectPublicKeyInfo) {
                return Optional.of(new JcaPEMKeyConverter().getPublicKey((SubjectPublicKeyInfo)readPEM));
            }
            LOGGER.warn("Key is not an instance of SubjectPublicKeyInfo but of {}", readPEM);
            return Optional.empty();
        }
        catch (IOException e) {
            LOGGER.warn("Error when reading the PEM file", (Throwable)e);
            return Optional.empty();
        }
    }
}

