/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.james.lifecycle.api.Startable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ChannelPool;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.RabbitFlux;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.ReceiverOptions;
import reactor.rabbitmq.Sender;
import reactor.rabbitmq.SenderOptions;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class ReactorRabbitMQChannelPool
implements ChannelPool,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorRabbitMQChannelPool.class);
    private static final long MAXIMUM_BORROW_TIMEOUT_IN_MS = Duration.ofSeconds(5L).toMillis();
    private static final int MAX_CHANNELS_NUMBER = 3;
    private static final int MAX_BORROW_RETRIES = 3;
    private static final Duration MIN_BORROW_DELAY = Duration.ofMillis(50L);
    private final Mono<Connection> connectionMono;
    private final GenericObjectPool<Channel> pool;
    private final ConcurrentSkipListSet<Channel> borrowedChannels;
    private final Configuration configuration;
    private Sender sender;

    public ReactorRabbitMQChannelPool(Mono<Connection> connectionMono, Configuration configuration) {
        this.connectionMono = connectionMono;
        this.configuration = configuration;
        ChannelFactory channelFactory = new ChannelFactory(connectionMono, configuration);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(configuration.getMaxChannel());
        this.pool = new GenericObjectPool((PooledObjectFactory)channelFactory, config);
        this.borrowedChannels = new ConcurrentSkipListSet<Channel>(Comparator.comparingInt(System::identityHashCode));
    }

    public void start() {
        this.sender = this.createSender();
    }

    public Sender getSender() {
        return this.sender;
    }

    public Receiver createReceiver() {
        return RabbitFlux.createReceiver((ReceiverOptions)new ReceiverOptions().connectionMono(this.connectionMono));
    }

    public Mono<? extends Channel> getChannelMono() {
        return this.borrow();
    }

    private Mono<Channel> borrow() {
        return this.tryBorrowFromPool().doOnError(throwable -> LOGGER.warn("Cannot borrow channel", throwable)).retryWhen((Retry)this.configuration.backoffSpec().scheduler(Schedulers.elastic())).onErrorMap(this::propagateException).subscribeOn(Schedulers.elastic()).doOnNext(this.borrowedChannels::add);
    }

    private Mono<Channel> tryBorrowFromPool() {
        return Mono.fromCallable(this::borrowFromPool);
    }

    private Throwable propagateException(Throwable throwable) {
        if (throwable instanceof IllegalStateException && throwable.getMessage().contains("Retries exhausted")) {
            return throwable.getCause();
        }
        return throwable;
    }

    private Channel borrowFromPool() throws Exception {
        Channel channel = (Channel)this.pool.borrowObject(MAXIMUM_BORROW_TIMEOUT_IN_MS);
        if (!channel.isOpen()) {
            this.invalidateObject(channel);
            throw new ChannelClosedException("borrowed channel is already closed");
        }
        return channel;
    }

    public BiConsumer<SignalType, Channel> getChannelCloseHandler() {
        return (signalType, channel) -> {
            this.borrowedChannels.remove(channel);
            if (!channel.isOpen() || signalType != SignalType.ON_COMPLETE) {
                this.invalidateObject((Channel)channel);
                return;
            }
            this.pool.returnObject(channel);
        };
    }

    private Sender createSender() {
        return RabbitFlux.createSender((SenderOptions)new SenderOptions().connectionMono(this.connectionMono).channelPool((ChannelPool)this).resourceManagementChannelMono(this.connectionMono.map((Function)Throwing.function(Connection::createChannel)).cache()));
    }

    public Mono<Void> createWorkQueue(QueueSpecification queueSpecification, BindingSpecification bindingSpecification) {
        Preconditions.checkArgument((queueSpecification.getName() != null ? 1 : 0) != 0, (Object)"WorkQueue pattern do not make sense for unnamed queues");
        Preconditions.checkArgument((boolean)queueSpecification.getName().equals(bindingSpecification.getQueue()), (String)"Binding needs to be targetting the created queue %s instead of %s", (Object)queueSpecification.getName(), (Object)bindingSpecification.getQueue());
        return Flux.concat((Publisher[])new Publisher[]{Mono.using(this::createSender, managementSender -> managementSender.declareQueue(queueSpecification), Sender::close).onErrorResume(e -> e instanceof ShutdownSignalException && e.getMessage().contains("reply-code=406, reply-text=PRECONDITION_FAILED - inequivalent arg 'x-dead-letter-exchange' for queue"), e -> {
            LOGGER.warn("{} already exists without dead-letter setup. Dead lettered messages to it will be lost. To solve this, re-create the queue with the x-dead-letter-exchange argument set up.", (Object)queueSpecification.getName());
            return Mono.empty();
        }), this.sender.bind(bindingSpecification)}).then();
    }

    private void invalidateObject(Channel channel) {
        try {
            this.pool.invalidateObject((Object)channel);
            if (channel.isOpen()) {
                channel.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void close() {
        this.sender.close();
        this.borrowedChannels.forEach(channel -> this.getChannelCloseHandler().accept(SignalType.ON_NEXT, (Channel)channel));
        this.borrowedChannels.clear();
        this.pool.close();
    }

    public Mono<Boolean> tryChannel() {
        return Mono.usingWhen(this.borrow(), channel -> Mono.just((Object)channel.isOpen()), channel -> {
            if (channel != null) {
                this.borrowedChannels.remove(channel);
                this.pool.returnObject(channel);
            }
            return Mono.empty();
        }).onErrorResume(any -> Mono.just((Object)false));
    }

    public static class Configuration {
        public static final Configuration DEFAULT = Configuration.builder().retries(3).minBorrowDelay(MIN_BORROW_DELAY).maxChannel(3);
        private final Duration minBorrowDelay;
        private final int retries;
        private final int maxChannel;

        public static RequiresRetries builder() {
            return retries -> minBorrowDelay -> maxChannel -> new Configuration(minBorrowDelay, retries, maxChannel);
        }

        public static Configuration from(org.apache.commons.configuration2.Configuration configuration) {
            Duration minBorrowDelay = Optional.ofNullable(configuration.getLong("channel.pool.min.delay.ms", null)).map(Duration::ofMillis).orElse(MIN_BORROW_DELAY);
            return Configuration.builder().retries(configuration.getInt("channel.pool.retries", 3)).minBorrowDelay(minBorrowDelay).maxChannel(configuration.getInt("channel.pool.size", 3));
        }

        public Configuration(Duration minBorrowDelay, int retries, int maxChannel) {
            this.minBorrowDelay = minBorrowDelay;
            this.retries = retries;
            this.maxChannel = maxChannel;
        }

        private RetryBackoffSpec backoffSpec() {
            return Retry.backoff((long)this.retries, (Duration)this.minBorrowDelay);
        }

        public int getMaxChannel() {
            return this.maxChannel;
        }

        @FunctionalInterface
        public static interface RequiredMaxChannel {
            public Configuration maxChannel(int var1);
        }

        @FunctionalInterface
        public static interface RequiredMinBorrowDelay {
            public RequiredMaxChannel minBorrowDelay(Duration var1);
        }

        @FunctionalInterface
        public static interface RequiresRetries {
            public RequiredMinBorrowDelay retries(int var1);
        }
    }

    static class ChannelFactory
    extends BasePooledObjectFactory<Channel> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFactory.class);
        private final Mono<Connection> connectionMono;
        private final Configuration configuration;

        ChannelFactory(Mono<Connection> connectionMono, Configuration configuration) {
            this.connectionMono = connectionMono;
            this.configuration = configuration;
        }

        public Channel create() {
            return (Channel)this.connectionMono.flatMap(this::openChannel).block();
        }

        private Mono<Channel> openChannel(Connection connection) {
            return Mono.fromCallable(() -> ((Connection)connection).openChannel()).map(maybeChannel -> (Channel)maybeChannel.orElseThrow(() -> new RuntimeException("RabbitMQ reached to maximum opened channels, cannot get more channels"))).retryWhen((Retry)this.configuration.backoffSpec().scheduler(Schedulers.elastic())).doOnError(throwable -> LOGGER.error("error when creating new channel", throwable));
        }

        public PooledObject<Channel> wrap(Channel obj) {
            return new DefaultPooledObject((Object)obj);
        }

        public void destroyObject(PooledObject<Channel> pooledObject) throws Exception {
            Channel channel = (Channel)pooledObject.getObject();
            if (channel.isOpen()) {
                channel.close();
            }
        }
    }

    private static class ChannelClosedException
    extends IOException {
        ChannelClosedException(String message) {
            super(message);
        }
    }
}

