/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.Booleans;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;
import org.apache.james.jmap.draft.model.mailbox.MailboxNamespace;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.jmap.draft.model.mailbox.Rights;
import org.apache.james.jmap.draft.model.mailbox.SortOrder;
import org.apache.james.jmap.draft.utils.quotas.DefaultQuotaLoader;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import reactor.core.publisher.Mono;

public class MailboxFactory {
    private final MailboxManager mailboxManager;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public MailboxFactory(MailboxManager mailboxManager, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver) {
        this.mailboxManager = mailboxManager;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    public MailboxBuilder builder() {
        DefaultQuotaLoader defaultQuotaLoader = new DefaultQuotaLoader(this.quotaRootResolver, this.quotaManager);
        return new MailboxBuilder(this, defaultQuotaLoader);
    }

    private Mailbox from(MailboxId mailboxId, MailboxPath mailboxPath, MailboxCounters.Sanitized mailboxCounters, MailboxACL resolvedAcl, Optional<List<MailboxMetaData>> userMailboxesMetadata, QuotaLoader quotaLoader, MailboxSession mailboxSession) throws MailboxException {
        boolean isOwner = mailboxPath.belongsTo(mailboxSession);
        Optional<Role> role = Role.from((String)mailboxPath.getName()).filter(any -> mailboxPath.belongsTo(mailboxSession));
        Rights rights = Rights.fromACL(resolvedAcl).removeEntriesFor(mailboxPath.getUser());
        Username username = mailboxSession.getUser();
        Quotas quotas = quotaLoader.getQuotas(mailboxPath);
        return Mailbox.builder().id(mailboxId).name(this.getName(mailboxPath, mailboxSession)).parentId(this.getParentIdFromMailboxPath(mailboxPath, userMailboxesMetadata, mailboxSession).orElse(null)).role(role).unreadMessages(mailboxCounters.getUnseen()).totalMessages(mailboxCounters.getCount()).sortOrder(SortOrder.getSortOrder(role)).sharedWith(rights).mayAddItems(rights.mayAddItems(username).orElse(isOwner)).mayCreateChild(rights.mayCreateChild(username).orElse(isOwner)).mayDelete(rights.mayDelete(username).orElse(isOwner)).mayReadItems(rights.mayReadItems(username).orElse(isOwner)).mayRemoveItems(rights.mayRemoveItems(username).orElse(isOwner)).mayRename(rights.mayRename(username).orElse(isOwner)).namespace(this.getNamespace(mailboxPath, isOwner)).quotas(quotas).build();
    }

    private MailboxNamespace getNamespace(MailboxPath mailboxPath, boolean isOwner) {
        if (isOwner) {
            return MailboxNamespace.personal();
        }
        return MailboxNamespace.delegated(mailboxPath.getUser());
    }

    @VisibleForTesting
    String getName(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        String name = mailboxPath.getName();
        if (name.contains(String.valueOf(mailboxSession.getPathDelimiter()))) {
            List levels = Splitter.on((char)mailboxSession.getPathDelimiter()).splitToList((CharSequence)name);
            return (String)levels.get(levels.size() - 1);
        }
        return name;
    }

    @VisibleForTesting
    Optional<MailboxId> getParentIdFromMailboxPath(MailboxPath mailboxPath, Optional<List<MailboxMetaData>> userMailboxesMetadata, MailboxSession mailboxSession) throws MailboxException {
        List levels = mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter());
        if (levels.size() <= 1) {
            return Optional.empty();
        }
        MailboxPath parent = (MailboxPath)levels.get(levels.size() - 2);
        return userMailboxesMetadata.map(list -> this.retrieveParentFromMetadata(parent, (List<MailboxMetaData>)list)).orElseGet(Throwing.supplier(() -> this.retrieveParentFromBackend(mailboxSession, parent)).sneakyThrow());
    }

    private Optional<MailboxId> retrieveParentFromBackend(MailboxSession mailboxSession, MailboxPath parent) throws MailboxException {
        return Optional.of(this.mailboxManager.getMailbox(parent, mailboxSession).getId());
    }

    private Optional<MailboxId> retrieveParentFromMetadata(MailboxPath parent, List<MailboxMetaData> list) {
        return list.stream().filter(metadata -> metadata.getPath().equals((Object)parent)).map(MailboxMetaData::getId).findAny();
    }

    public static class MailboxBuilder {
        private final MailboxFactory mailboxFactory;
        private QuotaLoader quotaLoader;
        private MailboxSession session;
        private Optional<MailboxId> id = Optional.empty();
        private Optional<MailboxMetaData> mailboxMetaData = Optional.empty();
        private Optional<List<MailboxMetaData>> userMailboxesMetadata = Optional.empty();

        private MailboxBuilder(MailboxFactory mailboxFactory, QuotaLoader quotaLoader) {
            this.mailboxFactory = mailboxFactory;
            this.quotaLoader = quotaLoader;
        }

        public MailboxBuilder id(MailboxId id) {
            this.id = Optional.of(id);
            return this;
        }

        public MailboxBuilder mailboxMetadata(MailboxMetaData mailboxMetaData) {
            this.mailboxMetaData = Optional.of(mailboxMetaData);
            return this;
        }

        public MailboxBuilder session(MailboxSession session) {
            this.session = session;
            return this;
        }

        public MailboxBuilder quotaLoader(QuotaLoader quotaLoader) {
            this.quotaLoader = quotaLoader;
            return this;
        }

        public MailboxBuilder usingPreloadedMailboxesMetadata(Optional<List<MailboxMetaData>> userMailboxesMetadata) {
            this.userMailboxesMetadata = userMailboxesMetadata;
            return this;
        }

        public Optional<Mailbox> build() {
            Preconditions.checkNotNull((Object)this.session);
            try {
                MailboxId mailboxId = this.computeMailboxId();
                Mono mailbox = this.mailbox(mailboxId).cache();
                MailboxACL mailboxACL = this.mailboxMetaData.map(MailboxMetaData::getResolvedAcls).orElseGet(Throwing.supplier(() -> this.retrieveCachedMailbox(mailboxId, (Mono<MessageManager>)mailbox).getResolvedAcl(this.session)).sneakyThrow());
                MailboxPath mailboxPath = this.mailboxMetaData.map(MailboxMetaData::getPath).orElseGet(Throwing.supplier(() -> this.retrieveCachedMailbox(mailboxId, (Mono<MessageManager>)mailbox).getMailboxPath()).sneakyThrow());
                MailboxCounters.Sanitized mailboxCounters = this.mailboxMetaData.map(MailboxMetaData::getCounters).orElseGet(Throwing.supplier(() -> this.retrieveCachedMailbox(mailboxId, (Mono<MessageManager>)mailbox).getMailboxCounters(this.session)).sneakyThrow()).sanitize();
                return Optional.of(this.mailboxFactory.from(mailboxId, mailboxPath, mailboxCounters, mailboxACL, this.userMailboxesMetadata, this.quotaLoader, this.session));
            }
            catch (MailboxNotFoundException e) {
                return Optional.empty();
            }
            catch (MailboxException e) {
                throw new RuntimeException(e);
            }
        }

        private MailboxId computeMailboxId() {
            int idCount = Booleans.countTrue((boolean[])new boolean[]{this.id.isPresent(), this.mailboxMetaData.isPresent()});
            Preconditions.checkState((idCount == 1 ? 1 : 0) != 0, (Object)"You need exactly one 'id' 'mailboxMetaData'");
            return this.id.or(() -> this.mailboxMetaData.map(MailboxMetaData::getId)).get();
        }

        private Mono<MessageManager> mailbox(MailboxId mailboxId) {
            return Mono.fromCallable(() -> this.mailboxFactory.mailboxManager.getMailbox(mailboxId, this.session));
        }

        private MessageManager retrieveCachedMailbox(MailboxId mailboxId, Mono<MessageManager> mailbox) throws MailboxNotFoundException {
            return (MessageManager)mailbox.onErrorResume(MailboxNotFoundException.class, any -> Mono.empty()).blockOptional().orElseThrow(() -> new MailboxNotFoundException(mailboxId));
        }
    }
}

