/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class BlobId {
    private final String rawValue;

    public static BlobId of(String rawValue) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)rawValue) ? 1 : 0) != 0, (Object)"'rawValue' is mandatory");
        return new BlobId(rawValue);
    }

    public static BlobId of(org.apache.james.mailbox.model.BlobId blobId) {
        return new BlobId(blobId.asString());
    }

    private BlobId(String rawValue) {
        this.rawValue = rawValue;
    }

    @JsonValue
    public String getRawValue() {
        return this.rawValue;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BlobId) {
            BlobId other = (BlobId)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.rawValue);
    }

    public String toString() {
        return "BlobId{rawValue='" + this.rawValue + "'}";
    }
}

