/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.RepublishNotprocessedMailsTask;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"MailQueues"})
@Path(value="/mailQueues")
@Produces(value={"application/json"})
public class RabbitMQMailQueuesRoutes
implements Routes {
    private static final TaskRegistrationKey REPUBLISH_NOT_PROCESSED_MAILS_REGISTRATION_KEY = TaskRegistrationKey.of((String)"RepublishNotProcessedMails");
    private final MailQueueFactory<RabbitMQMailQueue> mailQueueFactory;
    private final JsonTransformer jsonTransformer;
    private final TaskManager taskManager;
    private final Clock clock;

    @Inject
    @VisibleForTesting
    RabbitMQMailQueuesRoutes(MailQueueFactory<RabbitMQMailQueue> mailQueueFactory, Clock clock, JsonTransformer jsonTransformer, TaskManager taskManager) {
        this.mailQueueFactory = mailQueueFactory;
        this.clock = clock;
        this.jsonTransformer = jsonTransformer;
        this.taskManager = taskManager;
    }

    public String getBasePath() {
        return "/mailQueues";
    }

    public void define(Service service) {
        this.republishNotProcessedMails(service);
    }

    @POST
    @Path(value="/{mailQueueName}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="mailQueueName", paramType="path"), @ApiImplicitParam(required=true, dataType="String", name="action", paramType="query", example="?action=RepublishNotProcessedMails", value="Specify the action to perform on a RabbitMQ mail queue."), @ApiImplicitParam(required=true, dataType="String", name="olderThan", paramType="query", example="?olderThan=1w", value="Specify the messages minimum age to republish")})
    @ApiOperation(value="republish the not processed mails of the RabbitMQ MailQueue using the cassandra mail queue view")
    @ApiResponses(value={@ApiResponse(code=201, message="OK, the task for rebuilding the queue is created"), @ApiResponse(code=400, message="Invalid request for rebuilding the mail queue."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void republishNotProcessedMails(Service service) {
        TaskFromRequest taskFromRequest = this::republishNotProcessedMails;
        service.post("/mailQueues/:mailQueueName", TaskFromRequestRegistry.builder().register(REPUBLISH_NOT_PROCESSED_MAILS_REGISTRATION_KEY, this::republishNotProcessedMails).buildAsRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    private Task republishNotProcessedMails(Request request) {
        RabbitMQMailQueue mailQueue = this.getMailQueue(MailQueueName.of((String)request.params(":mailQueueName")));
        return new RepublishNotprocessedMailsTask(mailQueue, this.getOlderThan(request));
    }

    private RabbitMQMailQueue getMailQueue(MailQueueName mailQueueName) {
        return (RabbitMQMailQueue)this.mailQueueFactory.getQueue(mailQueueName).orElseThrow(() -> ErrorResponder.builder().message("%s can not be found", new Object[]{mailQueueName}).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError());
    }

    private Instant getOlderThan(Request req) {
        try {
            Duration olderThan = Optional.ofNullable(req.queryParams("olderThan")).filter(Predicate.not(String::isEmpty)).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.DAYS)).orElseThrow();
            return this.clock.instant().minus(olderThan);
        }
        catch (NoSuchElementException e) {
            throw ErrorResponder.builder().message("Missing olderThan").statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid olderThan").haltError();
        }
    }
}

