/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.memory;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.mailrepository.api.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailRepositoryStoreConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailRepositoryStoreConfiguration.class);
    private final List<Item> items;
    private final Optional<Protocol> defaultProtocol;

    public static MailRepositoryStoreConfiguration forItems(Item ... items) {
        return MailRepositoryStoreConfiguration.forItems((List<Item>)ImmutableList.copyOf((Object[])items));
    }

    public static MailRepositoryStoreConfiguration forItems(List<Item> items) {
        Optional<Protocol> defaultProtocol = MailRepositoryStoreConfiguration.computeDefaultProtocol(items);
        return new MailRepositoryStoreConfiguration(items, defaultProtocol);
    }

    public static MailRepositoryStoreConfiguration parse(HierarchicalConfiguration<ImmutableNode> configuration) {
        ImmutableList items = (ImmutableList)MailRepositoryStoreConfiguration.retrieveRegisteredClassConfiguration(configuration).stream().map(MailRepositoryStoreConfiguration::readItem).collect(Guavate.toImmutableList());
        Optional<Protocol> defaultProtocol = Optional.ofNullable(configuration.getString("defaultProtocol", null)).map(Protocol::new).or(() -> MailRepositoryStoreConfiguration.computeDefaultProtocol((List<Item>)items));
        return new MailRepositoryStoreConfiguration((List<Item>)items, defaultProtocol);
    }

    private static List<HierarchicalConfiguration<ImmutableNode>> retrieveRegisteredClassConfiguration(HierarchicalConfiguration<ImmutableNode> configuration) {
        try {
            return configuration.configurationsAt("mailrepositories.mailrepository");
        }
        catch (Exception e) {
            LOGGER.warn("Could not process configuration. Skipping Mail Repository initialization.", (Throwable)e);
            return ImmutableList.of();
        }
    }

    static Optional<Protocol> computeDefaultProtocol(List<Item> items) {
        return items.stream().flatMap(item -> item.getProtocols().stream()).findFirst();
    }

    private static Item readItem(HierarchicalConfiguration<ImmutableNode> configuration) {
        String className = configuration.getString("[@class]");
        List protocolStream = (List)Arrays.stream(configuration.getStringArray("protocols.protocol")).map(Protocol::new).collect(Guavate.toImmutableList());
        HierarchicalConfiguration<ImmutableNode> extraConfig = MailRepositoryStoreConfiguration.extraConfig(configuration);
        return new Item(protocolStream, className, extraConfig);
    }

    private static HierarchicalConfiguration<ImmutableNode> extraConfig(HierarchicalConfiguration<ImmutableNode> configuration) {
        if (configuration.getKeys("config").hasNext()) {
            return configuration.configurationAt("config");
        }
        return new BaseHierarchicalConfiguration();
    }

    public MailRepositoryStoreConfiguration(List<Item> items, Optional<Protocol> defaultProtocol) {
        this.items = items;
        this.defaultProtocol = defaultProtocol;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Optional<Protocol> getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public static class Item {
        private final List<Protocol> protocols;
        private final String classFqdn;
        private final HierarchicalConfiguration<ImmutableNode> configuration;

        public Item(List<Protocol> protocols, String classFqdn, HierarchicalConfiguration<ImmutableNode> configuration) {
            Preconditions.checkNotNull(protocols);
            Preconditions.checkNotNull((Object)classFqdn);
            Preconditions.checkNotNull(configuration);
            this.protocols = protocols;
            this.classFqdn = classFqdn;
            this.configuration = configuration;
        }

        public List<Protocol> getProtocols() {
            return this.protocols;
        }

        public String getClassFqdn() {
            return this.classFqdn;
        }

        public HierarchicalConfiguration<ImmutableNode> getConfiguration() {
            return this.configuration;
        }
    }
}

