/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.objectstorage.aws.AwsS3AuthConfiguration;
import org.apache.james.blob.objectstorage.aws.Region;

public class S3BlobStoreConfiguration {
    private final Region region;
    private final AwsS3AuthConfiguration specificAuthConfiguration;
    private final Optional<BucketName> namespace;
    private final Optional<String> bucketPrefix;

    public static Builder.RequireAuthConfiguration builder() {
        return authConfiguration -> region -> new Builder.ReadyToBuild(authConfiguration, region);
    }

    @VisibleForTesting
    S3BlobStoreConfiguration(Optional<String> bucketPrefix, Optional<BucketName> namespace, Region region, AwsS3AuthConfiguration specificAuthConfiguration) {
        this.bucketPrefix = bucketPrefix;
        this.namespace = namespace;
        this.region = region;
        this.specificAuthConfiguration = specificAuthConfiguration;
    }

    public Optional<BucketName> getNamespace() {
        return this.namespace;
    }

    public AwsS3AuthConfiguration getSpecificAuthConfiguration() {
        return this.specificAuthConfiguration;
    }

    public Optional<String> getBucketPrefix() {
        return this.bucketPrefix;
    }

    public Region getRegion() {
        return this.region;
    }

    public final boolean equals(Object o) {
        if (o instanceof S3BlobStoreConfiguration) {
            S3BlobStoreConfiguration that = (S3BlobStoreConfiguration)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.bucketPrefix, that.bucketPrefix) && Objects.equals(this.region, that.region) && Objects.equals(this.specificAuthConfiguration, that.specificAuthConfiguration);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.namespace, this.bucketPrefix, this.specificAuthConfiguration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", this.namespace).add("bucketPrefix", this.bucketPrefix).add("region", (Object)this.region).add("specificAuthConfiguration", (Object)this.specificAuthConfiguration).toString();
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final AwsS3AuthConfiguration specificAuthConfiguration;
            private Optional<BucketName> defaultBucketName;
            private Optional<String> bucketPrefix;
            private Region region;

            public ReadyToBuild(AwsS3AuthConfiguration specificAuthConfiguration, Region region) {
                this.specificAuthConfiguration = specificAuthConfiguration;
                this.region = region;
                this.defaultBucketName = Optional.empty();
                this.bucketPrefix = Optional.empty();
            }

            public ReadyToBuild defaultBucketName(Optional<BucketName> defaultBucketName) {
                this.defaultBucketName = defaultBucketName;
                return this;
            }

            public ReadyToBuild defaultBucketName(BucketName defaultBucketName) {
                this.defaultBucketName = Optional.of(defaultBucketName);
                return this;
            }

            public ReadyToBuild bucketPrefix(Optional<String> bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public ReadyToBuild bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = Optional.ofNullable(bucketPrefix);
                return this;
            }

            public S3BlobStoreConfiguration build() {
                return new S3BlobStoreConfiguration(this.bucketPrefix, this.defaultBucketName, this.region, this.specificAuthConfiguration);
            }
        }

        @FunctionalInterface
        public static interface RequireRegion {
            public ReadyToBuild region(Region var1);
        }

        @FunctionalInterface
        public static interface RequireAuthConfiguration {
            public RequireRegion authConfiguration(AwsS3AuthConfiguration var1);
        }
    }
}

