/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHookableCmdHandler<HookT extends Hook>
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHookableCmdHandler.class);
    private final MetricFactory metricFactory;
    private List<HookT> hooks;
    private List<HookResultHook> rHooks;

    @Inject
    public AbstractHookableCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public Response onCommand(SMTPSession session, Request request) {
        TimeMetric timeMetric = this.metricFactory.timer("SMTP-" + request.getCommand().toLowerCase(Locale.US));
        String command = request.getCommand();
        String parameters = request.getArgument();
        try {
            Response response;
            block19: {
                Response response2;
                Closeable closeable;
                block15: {
                    Response response3;
                    block18: {
                        block16: {
                            Response response4;
                            block17: {
                                closeable = MDCBuilder.create().addContext("action", (Object)command).build();
                                try {
                                    response2 = this.doFilterChecks(session, command, parameters);
                                    if (response2 != null) break block15;
                                    response2 = this.processHooks(session, command, parameters);
                                    if (response2 != null) break block16;
                                    response4 = this.doCoreCmd(session, command, parameters);
                                    if (closeable == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (closeable != null) {
                                            try {
                                                closeable.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                closeable.close();
                            }
                            return response4;
                        }
                        response3 = response2;
                        if (closeable == null) break block18;
                        closeable.close();
                    }
                    return response3;
                }
                response = response2;
                if (closeable == null) break block19;
                closeable.close();
            }
            return response;
        }
        finally {
            timeMetric.stopAndPublish();
        }
    }

    private Response processHooks(SMTPSession session, String command, String parameters) {
        List<HookT> hooks = this.getHooks();
        if (hooks != null) {
            int count = hooks.size();
            for (int i = 0; i < count; ++i) {
                Hook rawHook = (Hook)hooks.get(i);
                LOGGER.debug("executing hook {}", (Object)rawHook.getClass().getName());
                long start = System.currentTimeMillis();
                HookResult hRes = this.callHook(rawHook, session, parameters);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (HookResultHook rHook : this.rHooks) {
                        LOGGER.debug("executing hook {}", (Object)rHook);
                        hRes = rHook.onHookResult(session, hRes, executionTime, rawHook);
                    }
                }
                if (hRes.getResult().getAction() == HookReturnCode.Action.OK) {
                    final Response response = this.doCoreCmd(session, command, parameters);
                    if (hRes.getResult().isDisconnected()) {
                        return new Response(){

                            public boolean isEndSession() {
                                return true;
                            }

                            public String getRetCode() {
                                return response.getRetCode();
                            }

                            public List<CharSequence> getLines() {
                                return response.getLines();
                            }
                        };
                    }
                    return response;
                }
                SMTPResponse res = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    protected abstract HookResult callHook(HookT var1, SMTPSession var2, String var3);

    public static SMTPResponse calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            HookReturnCode returnCode = result.getResult();
            String smtpReturnCode = Optional.ofNullable(result.getSmtpRetCode()).or(() -> AbstractHookableCmdHandler.retrieveDefaultSmtpReturnCode(returnCode)).orElse(null);
            String smtpDescription = Optional.ofNullable(result.getSmtpDescription()).or(() -> AbstractHookableCmdHandler.retrieveDefaultSmtpDescription(returnCode)).orElse(null);
            if (AbstractHookableCmdHandler.canBeConvertedToSmtpAnswer(returnCode)) {
                SMTPResponse response = new SMTPResponse(smtpReturnCode, smtpDescription);
                if (returnCode.isDisconnected()) {
                    response.setEndSession(true);
                }
                return response;
            }
        }
        return null;
    }

    public static boolean canBeConvertedToSmtpAnswer(HookReturnCode returnCode) {
        return HookReturnCode.Action.ACTIVE_ACTIONS.contains((Object)returnCode.getAction()) || returnCode.isDisconnected();
    }

    private static Optional<String> retrieveDefaultSmtpDescription(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("Email rejected");
            }
            case DENYSOFT: {
                return Optional.of("Temporary problem. Please try again later");
            }
            case OK: {
                return Optional.of("Command accepted");
            }
        }
        if (returnCode.isDisconnected()) {
            return Optional.of("Server disconnected");
        }
        return Optional.empty();
    }

    private static Optional<String> retrieveDefaultSmtpReturnCode(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("554");
            }
            case DENYSOFT: {
                return Optional.of("451");
            }
            case OK: {
                return Optional.of("250");
            }
        }
        if (returnCode.isDisconnected()) {
            return Optional.of("554");
        }
        return Optional.empty();
    }

    protected abstract Response doFilterChecks(SMTPSession var1, String var2, String var3);

    protected abstract Response doCoreCmd(SMTPSession var1, String var2, String var3);

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(2);
        classes.add(this.getHookInterface());
        classes.add(HookResultHook.class);
        return classes;
    }

    protected abstract Class<HookT> getHookInterface();

    public void wireExtensions(Class<?> interfaceName, List<?> extension) {
        if (this.getHookInterface().equals(interfaceName)) {
            this.hooks = extension;
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<HookT> getHooks() {
        return this.hooks;
    }
}

