/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageIdMapper {
    public List<MailboxMessage> find(Collection<MessageId> var1, MessageMapper.FetchType var2);

    public Publisher<ComposedMessageIdWithMetaData> findMetadata(MessageId var1);

    default public Flux<MailboxMessage> findReactive(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return Flux.fromIterable(this.find(messageIds, fetchType));
    }

    public List<MailboxId> findMailboxes(MessageId var1);

    public void save(MailboxMessage var1) throws MailboxNotFoundException, MailboxException;

    public void copyInMailbox(MailboxMessage var1, Mailbox var2) throws MailboxException;

    public void delete(MessageId var1);

    public void delete(MessageId var1, Collection<MailboxId> var2);

    default public Mono<Void> deleteReactive(MessageId messageId, Collection<MailboxId> mailboxIds) {
        return Mono.fromRunnable(() -> this.delete(messageId, mailboxIds));
    }

    default public void delete(Multimap<MessageId, MailboxId> ids) {
        ids.asMap().forEach(this::delete);
    }

    public Multimap<MailboxId, UpdatedFlags> setFlags(MessageId var1, List<MailboxId> var2, Flags var3, MessageManager.FlagsUpdateMode var4) throws MailboxException;
}

