/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageMoves;

public class MessageMovesWithMailbox {
    private final ImmutableSet<Mailbox> previousMailboxes;
    private final ImmutableSet<Mailbox> targetMailboxes;

    public static Builder builder() {
        return new Builder();
    }

    private MessageMovesWithMailbox(Collection<Mailbox> previousMailboxes, Collection<Mailbox> targetMailboxes) {
        this.previousMailboxes = ImmutableSet.copyOf(previousMailboxes);
        this.targetMailboxes = ImmutableSet.copyOf(targetMailboxes);
    }

    public boolean isChange() {
        return !this.previousMailboxes.equals(this.targetMailboxes);
    }

    public Set<Mailbox> addedMailboxes() {
        return Sets.difference(this.targetMailboxes, this.previousMailboxes);
    }

    public Set<Mailbox> removedMailboxes() {
        return Sets.difference(this.previousMailboxes, this.targetMailboxes);
    }

    public ImmutableSet<Mailbox> getPreviousMailboxes() {
        return this.previousMailboxes;
    }

    public ImmutableSet<Mailbox> getTargetMailboxes() {
        return this.targetMailboxes;
    }

    public Stream<Mailbox> impactedMailboxes() {
        return Stream.concat(this.addedMailboxes().stream(), this.removedMailboxes().stream());
    }

    public MessageMovesWithMailbox filterPrevious(Predicate<Mailbox> predicate) {
        return MessageMovesWithMailbox.builder().targetMailboxes((Iterable<Mailbox>)this.targetMailboxes).previousMailboxes((Iterable)this.previousMailboxes.stream().filter(predicate).collect(Guavate.toImmutableSet())).build();
    }

    public MessageMovesWithMailbox filterTargets(Predicate<Mailbox> predicate) {
        return MessageMovesWithMailbox.builder().previousMailboxes((Iterable<Mailbox>)this.previousMailboxes).targetMailboxes((Iterable)this.targetMailboxes.stream().filter(predicate).collect(Guavate.toImmutableSet())).build();
    }

    public MessageMoves asMessageMoves() {
        return MessageMoves.builder().previousMailboxIds((Iterable)this.previousMailboxes.stream().map(Mailbox::getMailboxId).collect(Guavate.toImmutableSet())).targetMailboxIds((Iterable)this.targetMailboxes.stream().map(Mailbox::getMailboxId).collect(Guavate.toImmutableSet())).build();
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageMovesWithMailbox) {
            MessageMovesWithMailbox that = (MessageMovesWithMailbox)o;
            return Objects.equals(this.previousMailboxes, that.previousMailboxes) && Objects.equals(this.targetMailboxes, that.targetMailboxes);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.previousMailboxes, this.targetMailboxes);
    }

    public static class Builder {
        private final ImmutableSet.Builder<Mailbox> previousMailboxes = ImmutableSet.builder();
        private final ImmutableSet.Builder<Mailbox> targetMailboxes = ImmutableSet.builder();

        private Builder() {
        }

        public Builder previousMailboxes(Iterable<Mailbox> mailboxes) {
            this.previousMailboxes.addAll(mailboxes);
            return this;
        }

        public Builder previousMailboxes(Mailbox ... mailboxes) {
            this.previousMailboxes.addAll(Arrays.asList(mailboxes));
            return this;
        }

        public Builder targetMailboxes(Iterable<Mailbox> mailboxes) {
            this.targetMailboxes.addAll(mailboxes);
            return this;
        }

        public Builder targetMailboxes(Mailbox ... mailboxes) {
            this.targetMailboxes.addAll(Arrays.asList(mailboxes));
            return this;
        }

        public MessageMovesWithMailbox build() {
            return new MessageMovesWithMailbox((Collection<Mailbox>)this.previousMailboxes.build(), (Collection<Mailbox>)this.targetMailboxes.build());
        }
    }
}

