/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ExpressionFactoryAware;

public class ChoiceReifier
extends ProcessorReifier<ChoiceDefinition> {
    public ChoiceReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ProcessorDefinition)ChoiceDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            ExpressionFactory model;
            ExpressionFactoryAware aware;
            Predicate pre;
            ExpressionDefinition exp = whenClause.getExpression();
            if (exp.getExpressionType() != null) {
                exp = exp.getExpressionType();
            }
            if ((pre = exp.getPredicate()) instanceof ExpressionFactoryAware && (aware = (ExpressionFactoryAware)pre).getExpressionFactory() != null && (model = aware.getExpressionFactory()) instanceof ExpressionDefinition) {
                whenClause.setExpression((ExpressionDefinition)model);
            }
            FilterProcessor filter = (FilterProcessor)this.createProcessor((ProcessorDefinition<?>)whenClause);
            filters.add(filter);
        }
        Processor otherwiseProcessor = null;
        if (((ChoiceDefinition)this.definition).getOtherwise() != null) {
            otherwiseProcessor = this.createProcessor((ProcessorDefinition<?>)((ChoiceDefinition)this.definition).getOtherwise());
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }
}

