/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.SMTPConstants;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLineJamesMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataLineJamesMessageHookHandler.class);
    private List<JamesMessageHook> messageHandlers;
    private List<HookResultHook> rHooks;
    private List<MessageHook> mHandlers;

    /*
     * Exception decompiling
     */
    public Response onLine(SMTPSession session, ByteBuffer lineByteBuffer, LineHandler<SMTPSession> next) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 0[TRYBLOCK], 3[TRYBLOCK], 10[CATCHBLOCK], 1[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response processExtensions(SMTPSession session, Mail mail) {
        if (mail != null && this.messageHandlers != null) {
            try {
                Object response;
                long executionTime;
                HookResult hRes;
                long start;
                MimeMessageInputStreamSource mmiss = (MimeMessageInputStreamSource)session.getAttachment(SMTPConstants.DATA_MIMEMESSAGE_STREAMSOURCE, ProtocolSession.State.Transaction).orElseThrow(() -> new RuntimeException("'" + SMTPConstants.DATA_MIMEMESSAGE_STREAMSOURCE.asString() + "' has not been filled."));
                OutputStream out = mmiss.getWritableOutputStream();
                for (MessageHook rawHandler : this.mHandlers) {
                    LOGGER.debug("executing james message handler {}", (Object)rawHandler);
                    start = System.currentTimeMillis();
                    hRes = rawHandler.onMessage(session, (MailEnvelope)new MailToMailEnvelopeWrapper(mail, out));
                    executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        for (HookResultHook object : this.rHooks) {
                            LOGGER.debug("executing hook {}", (Object)object);
                            hRes = object.onHookResult(session, hRes, executionTime, (Hook)rawHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    SMTPResponse sMTPResponse = response;
                    return sMTPResponse;
                }
                for (JamesMessageHook messageHandler : this.messageHandlers) {
                    LOGGER.debug("executing james message handler {}", (Object)messageHandler);
                    start = System.currentTimeMillis();
                    hRes = messageHandler.onMessage(session, mail);
                    executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        response = this.rHooks.iterator();
                        while (response.hasNext()) {
                            HookResultHook hookResultHook = (HookResultHook)response.next();
                            LOGGER.debug("executing hook {}", (Object)hookResultHook);
                            hRes = hookResultHook.onHookResult(session, hRes, executionTime, (Hook)messageHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    Object object = response;
                    return object;
                }
            }
            finally {
                if (mail != null) {
                    LifecycleUtil.dispose((Object)mail);
                    mail = null;
                }
                session.resetState();
            }
        }
        return null;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (JamesMessageHook.class.equals(interfaceName)) {
            this.messageHandlers = extension;
            if (this.messageHandlers == null || this.messageHandlers.size() == 0) {
                throw new WiringException("No messageHandler configured");
            }
        } else if (MessageHook.class.equals(interfaceName)) {
            this.mHandlers = extension;
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(JamesMessageHook.class);
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }

    private static /* synthetic */ RuntimeException lambda$onLine$0() {
        return new RuntimeException("'" + SMTPConstants.DATA_MIMEMESSAGE_STREAMSOURCE.asString() + "' has not been filled.");
    }

    protected static class MailToMailEnvelopeWrapper
    implements MailEnvelope {
        private final Mail mail;
        private final OutputStream out;

        public MailToMailEnvelopeWrapper(Mail mail, OutputStream out) {
            this.mail = mail;
            this.out = out;
        }

        public InputStream getMessageInputStream() throws IOException {
            try {
                return new MimeMessageInputStream(this.mail.getMessage());
            }
            catch (MessagingException e) {
                throw new IOException("Unable to get inputstream for message", e);
            }
        }

        public OutputStream getMessageOutputStream() throws IOException {
            return this.out;
        }

        public List<MailAddress> getRecipients() {
            return ImmutableList.copyOf((Collection)this.mail.getRecipients());
        }

        public MaybeSender getMaybeSender() {
            return this.mail.getMaybeSender();
        }

        public long getSize() {
            try {
                return this.mail.getMessageSize();
            }
            catch (MessagingException e) {
                return -1L;
            }
        }
    }
}

