/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.HashSet;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.InvertingPackageScanFilter;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.SpringModelJAXBContextFactory;
import org.apache.camel.spring.spi.ApplicationContextBeanRepository;
import org.apache.camel.spring.spi.SpringInjector;
import org.apache.camel.spring.spi.SpringManagementMBeanAssembler;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.Phased;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class SpringCamelContext
extends DefaultCamelContext
implements Lifecycle,
ApplicationContextAware,
Phased,
ApplicationListener<ApplicationEvent>,
Ordered {
    public static final String EXCLUDE_ROUTES = "CamelTestSpringExcludeRoutes";
    private static final Logger LOG = LoggerFactory.getLogger(SpringCamelContext.class);
    private static final ThreadLocal<Boolean> NO_START = new ThreadLocal();
    private ApplicationContext applicationContext;
    private EventComponent eventComponent;
    private boolean shutdownEager = true;

    public SpringCamelContext() {
        super(false);
        if (Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            this.disableJMX();
        }
        this.setManagementMBeanAssembler((ManagementMBeanAssembler)new SpringManagementMBeanAssembler((CamelContext)this));
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this();
        this.setApplicationContext(applicationContext);
    }

    public static void setNoStart(boolean b) {
        if (b) {
            NO_START.set(true);
        } else {
            NO_START.set(null);
        }
    }

    @Deprecated
    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext, boolean maybeStart) throws Exception {
        String[] names;
        if (applicationContext != null && (names = applicationContext.getBeanNamesForType(SpringCamelContext.class)).length == 1) {
            return (SpringCamelContext)((Object)applicationContext.getBean(names[0], SpringCamelContext.class));
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        answer.build();
        if (maybeStart) {
            answer.start();
        }
        return answer;
    }

    public void start() {
        if (Boolean.TRUE.equals(NO_START.get())) {
            LOG.trace("Ignoring start() as NO_START is false");
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            try {
                StopWatch watch = new StopWatch();
                super.start();
                LOG.debug("start() took {} millis", (Object)watch.taken());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        } else {
            LOG.trace("Ignoring start() as Camel is already started");
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        LOG.debug("onApplicationEvent: {}", (Object)event);
        if (event instanceof ContextRefreshedEvent && ((ContextRefreshedEvent)event).getApplicationContext() == this.applicationContext) {
            this.start();
        }
        if (this.eventComponent != null) {
            this.eventComponent.onApplicationEvent(event);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ClassLoader cl;
        this.applicationContext = applicationContext;
        if (applicationContext != null && applicationContext.getClassLoader() != null) {
            cl = applicationContext.getClassLoader();
        } else {
            LOG.warn("Cannot find the class loader from application context, using the thread context class loader instead");
            cl = Thread.currentThread().getContextClassLoader();
        }
        LOG.debug("Set the application context classloader to: {}", (Object)cl);
        this.setApplicationContextClassLoader(cl);
        if (applicationContext instanceof ConfigurableApplicationContext && this.hasComponent("spring-event") == null) {
            this.eventComponent = new EventComponent(applicationContext);
            this.addComponent("spring-event", (Component)this.eventComponent);
        }
    }

    public boolean isShutdownEager() {
        return this.shutdownEager;
    }

    public void setShutdownEager(boolean shutdownEager) {
        this.shutdownEager = shutdownEager;
    }

    protected Injector createInjector() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            return new SpringInjector((ConfigurableApplicationContext)this.applicationContext);
        }
        LOG.warn("Cannot use SpringInjector as applicationContext is not a ConfigurableApplicationContext as its: {}", (Object)this.applicationContext);
        return super.createInjector();
    }

    protected EventEndpoint createEventEndpoint() {
        return (EventEndpoint)this.getEndpoint("spring-event:default", EventEndpoint.class);
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        Endpoint endpoint = (Endpoint)this.getTypeConverter().convertTo(Endpoint.class, bean);
        if (endpoint != null) {
            endpoint.setCamelContext((CamelContext)this);
            return endpoint;
        }
        return new ProcessorEndpoint(uri, (CamelContext)this, (Processor)new BeanProcessor(bean, (CamelContext)this));
    }

    protected Registry createRegistry() {
        ApplicationContextBeanRepository repository = new ApplicationContextBeanRepository(this.getApplicationContext());
        return new DefaultRegistry(new BeanRepository[]{repository});
    }

    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return new SpringModelJAXBContextFactory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SpringCamelContext(").append(this.getName()).append(")");
        if (this.applicationContext != null) {
            sb.append(" with spring id ").append(this.applicationContext.getId());
        }
        return sb.toString();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isRunning() {
        return !this.isStopping() && !this.isStopped();
    }

    protected PackageScanClassResolver createPackageScanClassResolver() {
        PackageScanClassResolver resolver = super.createPackageScanClassResolver();
        String excluded = System.getProperty(EXCLUDE_ROUTES);
        if (ObjectHelper.isNotEmpty((Object)excluded)) {
            HashSet<Class> excludedClasses = new HashSet<Class>();
            for (String str : excluded.split(",")) {
                excludedClasses.add(this.getClassResolver().resolveClass(str));
            }
            resolver.addFilter((PackageScanFilter)new InvertingPackageScanFilter((PackageScanFilter)new AssignableToPackageScanFilter(excludedClasses)));
        }
        return resolver;
    }
}

