/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Objects;

public class Algorithm {
    private static final boolean LEGACY = true;
    public static final Factory LEGACY_FACTORY = new LegacyFactory();
    public static final Factory DEFAULT_FACTORY = new DefaultFactory();
    private final String rawValue;
    private final boolean legacy;

    private Algorithm(String rawValue, boolean legacy) {
        this.rawValue = rawValue;
        this.legacy = legacy;
    }

    public String asString() {
        return this.rawValue;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public final boolean equals(Object o) {
        if (o instanceof Algorithm) {
            Algorithm that = (Algorithm)o;
            return Objects.equals(this.rawValue, that.rawValue) && Objects.equals(this.legacy, that.legacy);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.rawValue, this.legacy);
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        public Algorithm of(String rawValue) {
            return new Algorithm(rawValue, false);
        }
    }

    public static class LegacyFactory
    implements Factory {
        @Override
        public Algorithm of(String rawValue) {
            return new Algorithm(rawValue, true);
        }
    }

    public static interface Factory {
        public Algorithm of(String var1);
    }

    public static enum HashingMode {
        LEGACY(LEGACY_FACTORY),
        DEFAULT(DEFAULT_FACTORY);

        private final Factory factory;

        public static HashingMode parse(String value) {
            return Arrays.stream(HashingMode.values()).filter(aValue -> value.equalsIgnoreCase(aValue.toString())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsuported value for HashingMode: " + value + ". Should be one of " + ImmutableList.copyOf((Object[])HashingMode.values())));
        }

        private HashingMode(Factory factory) {
            this.factory = factory;
        }

        public Factory getFactory() {
            return this.factory;
        }
    }
}

