/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir.mail.model;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.maildir.MaildirMessageName;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.streaming.CountingInputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;

public class MaildirMessage
implements Message {
    private final MaildirMessageName messageName;
    private int bodyStartOctet;
    private final PropertyBuilder propertyBuilder = new PropertyBuilder();
    private boolean parsed;

    public MaildirMessage(MaildirMessageName messageName) {
        this.messageName = messageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void parseMessage() {
        block27: {
            if (this.parsed) {
                return;
            }
            try (SharedFileInputStream tmpMsgIn = new SharedFileInputStream(this.messageName.getFile());){
                String subType;
                String mediaType;
                this.bodyStartOctet = this.bodyStartOctet((InputStream)tmpMsgIn);
                MimeTokenStream parser = new MimeTokenStream(MimeConfig.PERMISSIVE, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder());
                parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
                parser.parse(tmpMsgIn.newStream(0L, -1L));
                EntityState next = parser.next();
                while (next != EntityState.T_BODY && next != EntityState.T_END_OF_STREAM && next != EntityState.T_START_MULTIPART) {
                    next = parser.next();
                }
                MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)parser.getBodyDescriptor();
                String mediaTypeFromHeader = descriptor.getMediaType();
                if (mediaTypeFromHeader == null) {
                    mediaType = "text";
                    subType = "plain";
                } else {
                    mediaType = mediaTypeFromHeader;
                    subType = descriptor.getSubType();
                }
                this.propertyBuilder.setMediaType(mediaType);
                this.propertyBuilder.setSubType(subType);
                this.propertyBuilder.setContentID(descriptor.getContentId());
                this.propertyBuilder.setContentDescription(descriptor.getContentDescription());
                this.propertyBuilder.setContentLocation(descriptor.getContentLocation());
                this.propertyBuilder.setContentMD5(descriptor.getContentMD5Raw());
                this.propertyBuilder.setContentTransferEncoding(descriptor.getTransferEncoding());
                this.propertyBuilder.setContentLanguage(descriptor.getContentLanguage());
                this.propertyBuilder.setContentDispositionType(descriptor.getContentDispositionType());
                this.propertyBuilder.setContentDispositionParameters(descriptor.getContentDispositionParameters());
                this.propertyBuilder.setContentTypeParameters(descriptor.getContentTypeParameters());
                String codeset = descriptor.getCharset();
                if (codeset == null) {
                    if ("TEXT".equalsIgnoreCase(mediaType)) {
                        this.propertyBuilder.setCharset("us-ascii");
                    }
                } else {
                    this.propertyBuilder.setCharset(codeset);
                }
                if (!"text".equalsIgnoreCase(mediaType)) break block27;
                long lines = -1L;
                try (CountingInputStream bodyStream = new CountingInputStream(parser.getInputStream());){
                    bodyStream.readAll();
                    lines = bodyStream.getLineCount();
                }
                next = parser.next();
                if (next == EntityState.T_EPILOGUE) {
                    try (CountingInputStream epilogueStream = new CountingInputStream(parser.getInputStream());){
                        epilogueStream.readAll();
                        lines += (long)epilogueStream.getLineCount();
                    }
                }
                this.propertyBuilder.setTextualLineCount(Long.valueOf(lines));
            }
            catch (IOException | MimeException throwable) {
            }
            finally {
                this.parsed = true;
            }
        }
    }

    private int bodyStartOctet(InputStream msgIn) throws IOException {
        int i;
        PushbackInputStream in = new PushbackInputStream(msgIn, 3);
        int localBodyStartOctet = in.available();
        int count = 0;
        while ((i = in.read()) != -1 && in.available() > 4) {
            if (i == 13) {
                int a = in.read();
                if (a == 10) {
                    int b = in.read();
                    if (b == 13) {
                        int c = in.read();
                        if (c == 10) {
                            localBodyStartOctet = count + 4;
                            break;
                        }
                        in.unread(c);
                    }
                    in.unread(b);
                }
                in.unread(a);
            }
            ++count;
        }
        return localBodyStartOctet;
    }

    public String getMediaType() {
        this.parseMessage();
        return this.propertyBuilder.build().getMediaType();
    }

    public String getSubType() {
        this.parseMessage();
        return this.propertyBuilder.build().getSubType();
    }

    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.getBodyStartOctet();
    }

    public long getFullContentOctets() {
        Long size = this.messageName.getSize();
        if (size != null) {
            return size;
        }
        try {
            return this.messageName.getFile().length();
        }
        catch (FileNotFoundException e) {
            return -1L;
        }
    }

    public long getHeaderOctets() {
        return this.getBodyStartOctet();
    }

    public Long getTextualLineCount() {
        this.parseMessage();
        return this.propertyBuilder.build().getTextualLineCount();
    }

    public Properties getProperties() {
        this.parseMessage();
        return this.propertyBuilder.build();
    }

    public MessageId getMessageId() {
        return new DefaultMessageId();
    }

    public Date getInternalDate() {
        return this.messageName.getInternalDate();
    }

    public InputStream getFullContent() throws IOException {
        return new FileInputStream(this.messageName.getFile());
    }

    public InputStream getBodyContent() throws IOException {
        this.parseMessage();
        FileInputStream body = new FileInputStream(this.messageName.getFile());
        IOUtils.skipFully((InputStream)body, (long)this.bodyStartOctet);
        return body;
    }

    private int getBodyStartOctet() {
        this.parseMessage();
        return this.bodyStartOctet;
    }

    public InputStream getHeaderContent() throws IOException {
        this.parseMessage();
        long limit = this.getBodyStartOctet();
        if (limit < 0L) {
            limit = 0L;
        }
        return ByteStreams.limit((InputStream)new FileInputStream(this.messageName.getFile()), (long)limit);
    }

    public List<MessageAttachmentMetadata> getAttachments() {
        List list;
        block8: {
            InputStream fullContent = this.getFullContent();
            try {
                AtomicInteger counter = new AtomicInteger(0);
                list = (List)new MessageParser().retrieveAttachments(fullContent).stream().map(Throwing.function(attachmentMetadata -> attachmentMetadata.asMessageAttachment(this.generateFixedAttachmentId(counter.incrementAndGet()))).sneakyThrow()).collect(Guavate.toImmutableList());
                if (fullContent == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fullContent != null) {
                        try {
                            fullContent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fullContent.close();
        }
        return list;
    }

    private AttachmentId generateFixedAttachmentId(int position) {
        return AttachmentId.from((String)(this.messageName.getFullName() + "-" + position));
    }
}

