/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.maildir.MaildirFolder;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;

public class MaildirStore
implements UidProvider,
ModSeqProvider {
    public static final String PATH_USER = "%user";
    public static final String PATH_DOMAIN = "%domain";
    public static final String PATH_FULLUSER = "%fulluser";
    public static final String WILDCARD = "%";
    public static final String maildirDelimiter = ".";
    private final String maildirLocation;
    private File maildirRootFile;
    private final MailboxPathLocker locker;
    private boolean messageNameStrictParse = false;

    public MaildirStore(String maildirLocation, MailboxPathLocker locker) {
        this.maildirLocation = maildirLocation;
        this.locker = locker;
    }

    public MaildirStore(String maildirLocation) {
        this(maildirLocation, (MailboxPathLocker)new JVMMailboxPathLocker());
    }

    public String getMaildirLocation() {
        return this.maildirLocation;
    }

    public MaildirFolder createMaildirFolder(Mailbox mailbox) throws MailboxNotFoundException {
        MaildirFolder mf = new MaildirFolder(this.getFolderName(mailbox), mailbox.generateAssociatedPath(), this.locker).validateWithinFolder(this.getMaildirRoot()).validateWithinFolder(new File(this.userRoot(mailbox.getUser())));
        mf.setMessageNameStrictParse(this.isMessageNameStrictParse());
        return mf;
    }

    public Mailbox loadMailbox(MailboxSession session, File root, String namespace, Username user, String folderName) throws MailboxException {
        String mailboxName = this.getMailboxNameFromFolderName(folderName);
        return this.loadMailbox(session, new File(root, folderName), new MailboxPath(namespace, user, mailboxName));
    }

    public Mailbox loadMailbox(MailboxSession session, MailboxPath mailboxPath) throws MailboxNotFoundException, MailboxException {
        MaildirFolder folder = new MaildirFolder(this.getFolderName(mailboxPath), mailboxPath, this.locker).validateWithinFolder(this.getMaildirRoot()).validateWithinFolder(new File(this.userRoot(session.getUser())));
        folder.setMessageNameStrictParse(this.isMessageNameStrictParse());
        if (!folder.exists()) {
            throw new MailboxNotFoundException(mailboxPath);
        }
        return this.loadMailbox(session, folder.getRootFile(), mailboxPath);
    }

    public Mailbox loadMailboxNoUserCheck(MailboxSession session, MailboxPath mailboxPath) throws MailboxNotFoundException, MailboxException {
        MaildirFolder folder = new MaildirFolder(this.getFolderName(mailboxPath), mailboxPath, this.locker).validateWithinFolder(this.getMaildirRoot());
        folder.setMessageNameStrictParse(this.isMessageNameStrictParse());
        if (!folder.exists()) {
            throw new MailboxNotFoundException(mailboxPath);
        }
        return this.loadMailboxNoChecks(session, folder.getRootFile(), mailboxPath);
    }

    private Mailbox loadMailbox(MailboxSession session, File mailboxFile, MailboxPath mailboxPath) throws MailboxException {
        MaildirFolder folder = new MaildirFolder(mailboxFile.getAbsolutePath(), mailboxPath, this.locker).validateWithinFolder(this.getMaildirRoot()).validateWithinFolder(new File(this.userRoot(session.getUser())));
        folder.setMessageNameStrictParse(this.isMessageNameStrictParse());
        try {
            Mailbox loadedMailbox = new Mailbox(mailboxPath, folder.getUidValidity(), (MailboxId)folder.readMailboxId());
            loadedMailbox.setACL(folder.getACL());
            return loadedMailbox;
        }
        catch (IOException e) {
            throw new MailboxException("Unable to load Mailbox " + mailboxPath, (Throwable)e);
        }
    }

    private Mailbox loadMailboxNoChecks(MailboxSession session, File mailboxFile, MailboxPath mailboxPath) throws MailboxException {
        MaildirFolder folder = new MaildirFolder(mailboxFile.getAbsolutePath(), mailboxPath, this.locker).validateWithinFolder(this.getMaildirRoot());
        folder.setMessageNameStrictParse(this.isMessageNameStrictParse());
        try {
            Mailbox loadedMailbox = new Mailbox(mailboxPath, folder.getUidValidity(), (MailboxId)folder.readMailboxId());
            loadedMailbox.setACL(folder.getACL());
            return loadedMailbox;
        }
        catch (IOException e) {
            throw new MailboxException("Unable to load Mailbox " + mailboxPath, (Throwable)e);
        }
    }

    public String userRoot(Username user) {
        String userName = user.asString();
        String path = this.maildirLocation.replace(PATH_FULLUSER, userName);
        String[] userParts = userName.split("@");
        if (userParts.length == 2) {
            userName = userParts[0];
            path = path.replace(PATH_DOMAIN, userParts[1].toLowerCase(Locale.US));
        }
        path = path.replace(PATH_USER, userName);
        return path;
    }

    public File getMailboxRootForUser(Username user) throws MailboxException {
        String path = this.userRoot(user);
        File root = new File(path);
        if (!root.isDirectory()) {
            throw new MailboxException("Unable to load Mailbox for user " + user);
        }
        return root;
    }

    public File getMaildirRoot() {
        if (this.maildirRootFile == null) {
            String maildirRootLocation = this.maildirLocation.replaceAll(PATH_FULLUSER, "");
            maildirRootLocation = maildirRootLocation.replaceAll(PATH_DOMAIN, "");
            maildirRootLocation = maildirRootLocation.replaceAll(PATH_USER, "");
            this.maildirRootFile = new File(maildirRootLocation);
        }
        return this.maildirRootFile;
    }

    public String getMailboxNameFromFolderName(String folderName) {
        String mName = folderName.equals("") ? "INBOX" : folderName.substring(1);
        return mName;
    }

    public String getFolderName(String namespace, Username user, String name) {
        String root = this.userRoot(user);
        if (name.equals("INBOX")) {
            return root;
        }
        StringBuilder folder = new StringBuilder(root);
        if (!root.endsWith(File.pathSeparator)) {
            folder.append(File.separator);
        }
        folder.append(maildirDelimiter);
        folder.append(name);
        return folder.toString();
    }

    public String getFolderName(Mailbox mailbox) {
        return this.getFolderName(mailbox.generateAssociatedPath());
    }

    public String getFolderName(MailboxPath mailboxPath) {
        return this.getFolderName(mailboxPath.getNamespace(), mailboxPath.getUser(), mailboxPath.getName());
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        try {
            return this.createMaildirFolder(mailbox).getLastUid().map(MessageUid::next).orElse(MessageUid.MIN_VALUE);
        }
        catch (MailboxException e) {
            throw new MailboxException("Unable to generate next uid", (Throwable)e);
        }
    }

    public ModSeq nextModSeq(Mailbox mailbox) {
        return ModSeq.of((long)System.currentTimeMillis());
    }

    public ModSeq highestModSeq(Mailbox mailbox) throws MailboxException {
        try {
            return this.createMaildirFolder(mailbox).getHighestModSeq();
        }
        catch (IOException e) {
            throw new MailboxException("Unable to get highest mod-sequence for mailbox", (Throwable)e);
        }
    }

    public Optional<MessageUid> lastUid(Mailbox mailbox) throws MailboxException {
        return this.createMaildirFolder(mailbox).getLastUid();
    }

    public boolean isMessageNameStrictParse() {
        return this.messageNameStrictParse;
    }

    public void setMessageNameStrictParse(boolean messageNameStrictParse) {
        this.messageNameStrictParse = messageNameStrictParse;
    }

    public ModSeq nextModSeq(MailboxId mailboxId) {
        return ModSeq.of((long)System.currentTimeMillis());
    }

    public MessageUid nextUid(MailboxId mailboxId) throws MailboxException {
        throw new NotImplementedException("Not implemented");
    }

    public ModSeq highestModSeq(MailboxId mailboxId) {
        throw new NotImplementedException("Not implemented");
    }
}

