/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.core.Username;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.jpa.model.JPAUser;
import org.apache.james.user.lib.UsersDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAUsersDAO
implements UsersDAO,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPAUsersDAO.class);
    private EntityManagerFactory entityManagerFactory;
    private String algo;

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.algo = config.getString("algorithm", "SHA-512");
    }

    public final void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void init() {
        EntityManagerUtils.safelyClose((EntityManager)this.createEntityManager());
    }

    public Optional<User> getUserByName(Username name) throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            JPAUser singleResult = (JPAUser)entityManager.createNamedQuery("findUserByName").setParameter("name", (Object)name.asString()).getSingleResult();
            Optional<User> optional = Optional.of(singleResult);
            return optional;
        }
        catch (NoResultException e) {
            Optional<User> optional = Optional.empty();
            return optional;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Unable to search user", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public void updateUser(User user) throws UsersRepositoryException {
        block7: {
            Preconditions.checkNotNull((Object)user);
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            EntityTransaction transaction = entityManager.getTransaction();
            try {
                if (this.contains(user.getUserName())) {
                    transaction.begin();
                    entityManager.merge((Object)user);
                    transaction.commit();
                    break block7;
                }
                LOGGER.debug("User not found");
                throw new UsersRepositoryException("User " + user.getUserName() + " not found");
            }
            catch (PersistenceException e) {
                LOGGER.debug("Failed to update user", (Throwable)e);
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                throw new UsersRepositoryException("Failed to update user " + user.getUserName().asString(), (Throwable)e);
            }
            finally {
                EntityManagerUtils.safelyClose((EntityManager)entityManager);
            }
        }
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (entityManager.createNamedQuery("deleteUserByName").setParameter("name", (Object)name.asString()).executeUpdate() < 1) {
                transaction.commit();
                throw new UsersRepositoryException("User " + name.asString() + " does not exist");
            }
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to remove user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new UsersRepositoryException("Failed to remove user " + name.asString(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public boolean contains(Username name) throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            boolean bl = (Long)entityManager.createNamedQuery("containsUser").setParameter("name", (Object)name.asString().toLowerCase(Locale.US)).getSingleResult() > 0L;
            return bl;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Failed to find user" + name.asString(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public int countUsers() throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            int n = ((Long)entityManager.createNamedQuery("countUsers").getSingleResult()).intValue();
            return n;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Failed to count users", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Iterator<Username> list() throws UsersRepositoryException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)entityManager.createNamedQuery("listUserNames").getResultList().stream().map(Username::of).collect(Guavate.toImmutableList())).iterator();
            return unmodifiableIterator;
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to find user", (Throwable)e);
            throw new UsersRepositoryException("Failed to list users", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public void addUser(Username username, String password) throws UsersRepositoryException {
        Username lowerCasedUsername = Username.of((String)username.asString().toLowerCase(Locale.US));
        if (this.contains(lowerCasedUsername)) {
            throw new UsersRepositoryException(lowerCasedUsername.asString() + " already exists.");
        }
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            JPAUser user = new JPAUser(lowerCasedUsername.asString(), password, this.algo);
            entityManager.persist((Object)user);
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.debug("Failed to save user", (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new UsersRepositoryException("Failed to add user" + username.asString(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }
}

