/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.file;

import com.github.steveash.guavate.Guavate;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.file.FileCacheableMailQueue;

@Deprecated
public class FileMailQueueFactory
implements MailQueueFactory<ManageableMailQueue> {
    private final Map<MailQueueName, ManageableMailQueue> queues = new ConcurrentHashMap<MailQueueName, ManageableMailQueue>();
    private MailQueueItemDecoratorFactory mailQueueActionItemDecoratorFactory;
    private FileSystem fs;
    private boolean sync = true;

    @Inject
    public FileMailQueueFactory(FileSystem fs, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory) {
        this.fs = fs;
        this.mailQueueActionItemDecoratorFactory = mailQueueItemDecoratorFactory;
    }

    public Set<MailQueueName> listCreatedMailQueues() {
        return (Set)this.queues.values().stream().map(MailQueue::getName).collect(Guavate.toImmutableSet());
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Optional<ManageableMailQueue> getQueue(MailQueueName name, MailQueueFactory.PrefetchCount prefetchCount) {
        return Optional.ofNullable(this.queues.get(name));
    }

    public ManageableMailQueue createQueue(MailQueueName name, MailQueueFactory.PrefetchCount prefetchCount) {
        return this.queues.computeIfAbsent(name, mailQueueName -> {
            try {
                return new FileCacheableMailQueue(this.mailQueueActionItemDecoratorFactory, this.fs.getFile("file://var/store/queue"), (MailQueueName)mailQueueName, this.sync);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to access queue " + mailQueueName.asString(), e);
            }
        });
    }
}

