/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.StatusRequest;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusProcessor
extends AbstractMailboxProcessor<StatusRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusProcessor.class);

    public StatusProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(StatusRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(StatusRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        StatusDataItems statusDataItems = request.getStatusDataItems();
        MailboxSession mailboxSession = session.getMailboxSession();
        try {
            LOGGER.debug("Status called on mailbox named {}", (Object)mailboxPath);
            MessageManager.MailboxMetaData metaData = this.retrieveMetadata(mailboxPath, statusDataItems, mailboxSession);
            MailboxStatusResponse response = this.computeStatusResponse(request, statusDataItems, metaData);
            if (response.getHighestModSeq() != null) {
                this.condstoreEnablingCommand(session, responder, metaData, false);
            }
            responder.respond(response);
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(request, responder);
        }
        catch (MailboxException e) {
            LOGGER.error("Status failed for mailbox {}", (Object)mailboxPath, (Object)e);
            this.no(request, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    private MessageManager.MailboxMetaData retrieveMetadata(MailboxPath mailboxPath, StatusDataItems statusDataItems, MailboxSession mailboxSession) throws MailboxException {
        MessageManager mailbox = this.getMailboxManager().getMailbox(mailboxPath, mailboxSession);
        MessageManager.MailboxMetaData.FetchGroup fetchGroup = this.computeFetchGroup(statusDataItems);
        return mailbox.getMetaData(false, mailboxSession, fetchGroup);
    }

    private MailboxStatusResponse computeStatusResponse(StatusRequest request, StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        Long messages = this.messages(statusDataItems, metaData);
        Long recent = this.recent(statusDataItems, metaData);
        MessageUid uidNext = this.uidNext(statusDataItems, metaData);
        UidValidity uidValidity = this.uidValidity(statusDataItems, metaData);
        Long unseen = this.unseen(statusDataItems, metaData);
        ModSeq highestModSeq = this.highestModSeq(statusDataItems, metaData);
        return new MailboxStatusResponse(messages, recent, uidNext, highestModSeq, uidValidity, unseen, request.getMailboxName());
    }

    private MessageManager.MailboxMetaData.FetchGroup computeFetchGroup(StatusDataItems statusDataItems) {
        if (statusDataItems.isUnseen()) {
            return MessageManager.MailboxMetaData.FetchGroup.UNSEEN_COUNT;
        }
        return MessageManager.MailboxMetaData.FetchGroup.NO_UNSEEN;
    }

    private Long unseen(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isUnseen()) {
            return metaData.getUnseenCount();
        }
        return null;
    }

    private UidValidity uidValidity(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isUidValidity()) {
            return metaData.getUidValidity();
        }
        return null;
    }

    private ModSeq highestModSeq(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isHighestModSeq()) {
            return metaData.getHighestModSeq();
        }
        return null;
    }

    private MessageUid uidNext(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isUidNext()) {
            return metaData.getUidNext();
        }
        return null;
    }

    private Long recent(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isRecent()) {
            return metaData.countRecent();
        }
        return null;
    }

    private Long messages(StatusDataItems statusDataItems, MessageManager.MailboxMetaData metaData) {
        if (statusDataItems.isMessages()) {
            return metaData.getMessageCount();
        }
        return null;
    }

    @Override
    protected Closeable addContextToMDC(StatusRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"STATUS").addContext("mailbox", (Object)request.getMailboxName()).addContext("parameters", (Object)request.getStatusDataItems()).build();
    }
}

