/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.SetACLRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetACLProcessor
extends AbstractMailboxProcessor<SetACLRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetACLProcessor.class);
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_ACL);

    public SetACLProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SetACLRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(SetACLRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        String mailboxName = request.getMailboxName();
        String identifier = request.getIdentifier();
        try {
            MailboxACL.EditMode editMode = MailboxACL.EditMode.REPLACE;
            String rights = request.getRights();
            if (rights != null && rights.length() > 0) {
                switch (rights.charAt(0)) {
                    case '+': {
                        editMode = MailboxACL.EditMode.ADD;
                        rights = rights.substring(1);
                        break;
                    }
                    case '-': {
                        editMode = MailboxACL.EditMode.REMOVE;
                        rights = rights.substring(1);
                    }
                }
            }
            MailboxACL.Rfc4314Rights mailboxAclRights = MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)rights);
            MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            mailboxManager.getMailbox(mailboxPath, mailboxSession);
            if (!mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Lookup, mailboxSession)) {
                this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            } else if (!mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Administer, mailboxSession)) {
                Object[] params = new Object[]{MailboxACL.Right.Administer.toString(), request.getCommand().getName(), mailboxName};
                HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(request, responder, text);
            } else {
                MailboxACL.EntryKey key = MailboxACL.EntryKey.deserialize((String)identifier);
                mailboxManager.applyRightsCommand(mailboxPath, MailboxACL.command().key(key).mode(editMode).rights(mailboxAclRights).build(), mailboxSession);
                this.okComplete(request, responder);
            }
        }
        catch (UnsupportedRightException e) {
            Object[] params = new Object[]{Character.valueOf(e.getUnsupportedRight())};
            HumanReadableText text = new HumanReadableText("org.apache.james.imap.UNSUPPORTED_RIGHT", "The {0} right is not supported.", params);
            this.taggedBad(request, responder, text);
        }
        catch (MailboxNotFoundException e) {
            this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            LOGGER.error("{} failed for mailbox {}", new Object[]{request.getCommand().getName(), mailboxName, e});
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Closeable addContextToMDC(SetACLRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"SET_ACL").addContext("mailbox", (Object)request.getMailboxName()).addContext("identifier", (Object)request.getIdentifier()).addContext("rights", (Object)request.getRights()).build();
    }
}

