/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.GetQuotaRootRequest;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.imap.message.response.QuotaRootResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class GetQuotaRootProcessor
extends AbstractMailboxProcessor<GetQuotaRootRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_QUOTA);
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;

    public GetQuotaRootProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MetricFactory metricFactory) {
        super(GetQuotaRootRequest.class, next, mailboxManager, factory, metricFactory);
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected void processRequest(GetQuotaRootRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        try {
            if (mailboxManager.hasRight(mailboxPath, MailboxACL.Right.Read, mailboxSession)) {
                QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
                QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
                Quota messageQuota = quotas.getMessageQuota();
                Quota storageQuota = quotas.getStorageQuota();
                responder.respond(new QuotaRootResponse(request.getMailboxName(), quotaRoot.getValue()));
                if (((QuotaCountLimit)messageQuota.getLimit()).isLimited()) {
                    responder.respond(new QuotaResponse("MESSAGE", quotaRoot.getValue(), messageQuota));
                }
                if (((QuotaSizeLimit)storageQuota.getLimit()).isLimited()) {
                    responder.respond(new QuotaResponse("STORAGE", quotaRoot.getValue(), storageQuota));
                }
                this.okComplete(request, responder);
            } else {
                Object[] params = new Object[]{MailboxACL.Right.Read.toString(), request.getCommand().getName(), request.getMailboxName()};
                HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(request, responder, humanReadableText);
            }
        }
        catch (MailboxException me) {
            this.taggedBad(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
        }
    }

    @Override
    protected Closeable addContextToMDC(GetQuotaRootRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"GET_QUOTA_ROOT").addContext("mailbox", (Object)request.getMailboxName()).build();
    }
}

