/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.BitSet;
import java.util.Objects;

public class ArrayStateImage {
    public static Object[] newImage(int numFields) {
        Object[] state = new Object[numFields + 1];
        state[numFields] = new BitSet(numFields);
        return state;
    }

    public static boolean isImage(Object obj) {
        if (!(obj instanceof Object[])) {
            return false;
        }
        Object[] arr = (Object[])obj;
        return arr.length > 0 && arr[arr.length - 1] instanceof BitSet;
    }

    public static BitSet getLoaded(Object[] state) {
        return (BitSet)state[state.length - 1];
    }

    public static void setLoaded(Object[] state, BitSet loaded) {
        state[state.length - 1] = loaded;
    }

    public static Object[] clone(Object[] state) {
        Object[] copy = new Object[state.length];
        System.arraycopy(state, 0, copy, 0, state.length - 1);
        BitSet loaded = (BitSet)state[state.length - 1];
        copy[copy.length - 1] = loaded.clone();
        return copy;
    }

    public static boolean sameVersion(Object[] state1, Object[] state2) {
        if (state1 == state2) {
            return true;
        }
        if (state1 == null || state2 == null) {
            return true;
        }
        BitSet loaded1 = ArrayStateImage.getLoaded(state1);
        BitSet loaded2 = ArrayStateImage.getLoaded(state2);
        int max = loaded1.length();
        for (int i = 0; i < max; ++i) {
            if (!loaded1.get(i) || !loaded2.get(i) || Objects.equals(state1[i], state2[i])) continue;
            return false;
        }
        return true;
    }
}

