/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap.retry;

import org.apache.james.user.ldap.retry.api.RetrySchedule;

public class DoublingRetrySchedule
implements RetrySchedule {
    private long startInterval = 0L;
    private long maxInterval = 0L;
    private long multiplier = 1L;

    private DoublingRetrySchedule() {
    }

    public DoublingRetrySchedule(long startInterval, long maxInterval) {
        this(startInterval, maxInterval, 1);
    }

    public DoublingRetrySchedule(long startInterval, long maxInterval, int multiplier) {
        this();
        this.startInterval = Math.max(0L, startInterval);
        this.maxInterval = Math.max(0L, maxInterval);
        this.multiplier = Math.max(1, multiplier);
    }

    @Override
    public long getInterval(int index) {
        if (this.startInterval > 0L) {
            return this.getInterval(index, this.startInterval);
        }
        return index == 0 ? 0L : this.getInterval(index - 1, 1L);
    }

    private long getInterval(int index, long startInterval) {
        return this.multiplier * Math.min((long)((double)startInterval * Math.pow(2.0, index)), this.maxInterval);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DoublingRetrySchedule [startInterval=").append(this.startInterval).append(", maxInterval=").append(this.maxInterval).append(", multiplier=").append(this.multiplier).append("]");
        return builder.toString();
    }
}

