/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.dlp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.transport.matchers.dlp.DlpRulesLoader;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class Dlp
extends GenericMatcher {
    private static final AttributeName DLP_MATCHED_RULE = AttributeName.of((String)"DlpMatchedRule");
    private final DlpRulesLoader rulesLoader;

    @VisibleForTesting
    Dlp(DlpRulesLoader rulesLoader) {
        this.rulesLoader = rulesLoader;
    }

    @Inject
    public Dlp(DLPConfigurationStore configurationStore) {
        this(new DlpRulesLoader.Impl(configurationStore));
    }

    public Collection<MailAddress> match(Mail mail) {
        Optional<DLPConfigurationItem.Id> firstMatchingRuleId = this.findFirstMatchingRule(mail);
        if (firstMatchingRuleId.isPresent()) {
            DLPConfigurationItem.Id ruleId = firstMatchingRuleId.get();
            this.setRuleIdAsMailAttribute(mail, ruleId);
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }

    private void setRuleIdAsMailAttribute(Mail mail, DLPConfigurationItem.Id ruleId) {
        mail.setAttribute(new Attribute(DLP_MATCHED_RULE, AttributeValue.of((String)ruleId.asString())));
    }

    private Optional<DLPConfigurationItem.Id> findFirstMatchingRule(Mail mail) {
        return mail.getMaybeSender().asOptional().flatMap(sender -> this.matchingRule((MailAddress)sender, mail));
    }

    private Optional<DLPConfigurationItem.Id> matchingRule(MailAddress address, Mail mail) {
        return this.rulesLoader.load(address.getDomain()).match(mail);
    }

    public String getMatcherInfo() {
        return "Data Leak Prevention Matcher";
    }
}

