/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends InputStream {
    private final InputStream in;
    private int lineCount;
    private int octetCount;

    public CountingInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int next = this.in.read();
        if (next > 0) {
            ++this.octetCount;
            if (next == 13) {
                ++this.lineCount;
            }
        }
        return next;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getOctetCount() {
        return this.octetCount;
    }

    public void readAll() throws IOException {
        while (this.read() > 0) {
        }
    }
}

