/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreAttachmentManager
implements AttachmentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreAttachmentManager.class);
    private final AttachmentMapperFactory attachmentMapperFactory;
    private final MessageIdManager messageIdManager;

    @Inject
    public StoreAttachmentManager(AttachmentMapperFactory attachmentMapperFactory, MessageIdManager messageIdManager) {
        this.attachmentMapperFactory = attachmentMapperFactory;
        this.messageIdManager = messageIdManager;
    }

    public boolean exists(AttachmentId attachmentId, MailboxSession session) throws MailboxException {
        return this.userHasAccessToAttachment(attachmentId, session);
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException, AttachmentNotFoundException {
        if (!this.userHasAccessToAttachment(attachmentId, mailboxSession)) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getAttachment(attachmentId);
    }

    public List<AttachmentMetadata> getAttachments(List<AttachmentId> attachmentIds, MailboxSession mailboxSession) throws MailboxException {
        Collection<AttachmentId> accessibleAttachmentIds = this.keepAccessible(attachmentIds, mailboxSession);
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getAttachments(accessibleAttachmentIds);
    }

    public Publisher<AttachmentMetadata> storeAttachment(ContentType contentType, InputStream attachmentContent, MailboxSession mailboxSession) {
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).storeAttachmentForOwner(contentType, attachmentContent, mailboxSession.getUser());
    }

    private boolean userHasAccessToAttachment(AttachmentId attachmentId, MailboxSession mailboxSession) {
        try {
            return this.isExplicitlyAOwner(attachmentId, mailboxSession) || this.isReferencedInUserMessages(attachmentId, mailboxSession);
        }
        catch (MailboxException e) {
            LOGGER.warn("Error while checking attachment related accessible message ids", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Collection<AttachmentId> keepAccessible(Collection<AttachmentId> attachmentIds, MailboxSession mailboxSession) {
        try {
            Set<AttachmentId> referencedByMessages = this.referencedInUserMessages(attachmentIds, mailboxSession);
            ImmutableSet owned = (ImmutableSet)Sets.difference((Set)ImmutableSet.copyOf(attachmentIds), referencedByMessages).stream().filter(Throwing.predicate(id -> this.isExplicitlyAOwner((AttachmentId)id, mailboxSession)).sneakyThrow()).collect(Guavate.toImmutableSet());
            return ImmutableSet.builder().addAll(referencedByMessages).addAll((Iterable)owned).build();
        }
        catch (MailboxException e) {
            LOGGER.warn("Error while checking attachment related accessible message ids", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isReferencedInUserMessages(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException {
        Collection<MessageId> relatedMessageIds = this.getRelatedMessageIds(attachmentId, mailboxSession);
        return !this.messageIdManager.accessibleMessages(relatedMessageIds, mailboxSession).isEmpty();
    }

    private Set<AttachmentId> referencedInUserMessages(Collection<AttachmentId> attachmentIds, MailboxSession mailboxSession) throws MailboxException {
        ImmutableMap entries = ((ImmutableListMultimap)attachmentIds.stream().flatMap(Throwing.function(attachmentId -> this.getRelatedMessageIds((AttachmentId)attachmentId, mailboxSession).stream().map(messageId -> Pair.of((Object)messageId, (Object)attachmentId))).sneakyThrow()).collect(Guavate.toImmutableListMultimap(Pair::getKey, Pair::getValue))).asMap();
        Set accessibleMessages = this.messageIdManager.accessibleMessages(entries.keySet(), mailboxSession);
        return (Set)entries.entrySet().stream().filter(entry -> accessibleMessages.contains(entry.getKey())).flatMap(entry -> ((Collection)entry.getValue()).stream()).collect(Guavate.toImmutableSet());
    }

    private boolean isExplicitlyAOwner(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException {
        Collection<Username> explicitOwners = this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getOwners(attachmentId);
        return explicitOwners.stream().anyMatch(username -> mailboxSession.getUser().equals(username));
    }

    private Collection<MessageId> getRelatedMessageIds(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException {
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getRelatedMessageIds(attachmentId);
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId, MailboxSession mailboxSession) throws AttachmentNotFoundException, IOException {
        if (!this.userHasAccessToAttachment(attachmentId, mailboxSession)) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).loadAttachmentContent(attachmentId);
    }
}

