/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.api.message.request.SearchOperation;
import org.apache.james.imap.api.message.request.SearchResultOption;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.SearchRequest;
import org.apache.james.imap.message.response.ESearchResponse;
import org.apache.james.imap.message.response.SearchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class SearchProcessor
extends AbstractMailboxProcessor<SearchRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchProcessor.class);
    protected static final String SEARCH_MODSEQ = "SEARCH_MODSEQ";
    private static final List<Capability> CAPS = ImmutableList.of((Object)Capability.of("WITHIN"), (Object)Capability.of("ESEARCH"), (Object)Capability.of("SEARCHRES"));

    public SearchProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SearchRequest.class, next, mailboxManager, factory, metricFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRequest(SearchRequest request, ImapSession session, ImapProcessor.Responder responder) {
        SearchOperation operation = request.getSearchOperation();
        SearchKey searchKey = operation.getSearchKey();
        boolean useUids = request.isUseUids();
        List<SearchResultOption> resultOptions = operation.getResultOptions();
        try {
            ImapResponseMessage response;
            ModSeq highestModSeq;
            MessageManager mailbox = this.getSelectedMailbox(session).orElseThrow(() -> new MailboxException("Session not in SELECTED state"));
            SearchQuery query = this.toQuery(searchKey, session);
            MailboxSession msession = session.getMailboxSession();
            Collection<MessageUid> uids = this.performUidSearch(mailbox, query, msession);
            Collection<Long> results = this.asResults(session, useUids, uids);
            if (session.getAttribute(SEARCH_MODSEQ) != null) {
                MessageManager.MailboxMetaData metaData = mailbox.getMetaData(false, msession, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT);
                highestModSeq = this.findHighestModSeq(msession, mailbox, MessageRange.toRanges(uids), metaData.getHighestModSeq());
                this.condstoreEnablingCommand(session, responder, metaData, true);
            } else {
                highestModSeq = null;
            }
            long[] ids = this.toArray(results);
            if (resultOptions == null || resultOptions.isEmpty()) {
                response = new SearchResponse(ids, highestModSeq);
            } else {
                ArrayList<Long> idList = new ArrayList<Long>(ids.length);
                for (long id : ids) {
                    idList.add(id);
                }
                ArrayList<IdRange> idsAsRanges = new ArrayList<IdRange>();
                for (Long id : idList) {
                    idsAsRanges.add(new IdRange(id));
                }
                IdRange[] idRanges = (IdRange[])IdRange.mergeRanges(idsAsRanges).toArray(IdRange[]::new);
                ArrayList<UidRange> uidsAsRanges = new ArrayList<UidRange>();
                for (MessageUid uid : uids) {
                    uidsAsRanges.add(new UidRange(uid));
                }
                UidRange[] uidRanges = (UidRange[])UidRange.mergeRanges(uidsAsRanges).toArray(UidRange[]::new);
                boolean esearch = false;
                for (SearchResultOption resultOption : resultOptions) {
                    if (SearchResultOption.SAVE == resultOption) continue;
                    esearch = true;
                    break;
                }
                if (esearch) {
                    long min = -1L;
                    long max = -1L;
                    long count = ids.length;
                    if (ids.length > 0) {
                        min = ids[0];
                        max = ids[ids.length - 1];
                    }
                    if (resultOptions.contains((Object)SearchResultOption.SAVE)) {
                        if (resultOptions.contains((Object)SearchResultOption.ALL) || resultOptions.contains((Object)SearchResultOption.COUNT)) {
                            SearchResUtil.saveSequenceSet(session, idRanges);
                        } else {
                            ArrayList<IdRange> savedRanges = new ArrayList<IdRange>();
                            if (resultOptions.contains((Object)SearchResultOption.MIN)) {
                                savedRanges.add(new IdRange(min));
                            }
                            if (resultOptions.contains((Object)SearchResultOption.MAX)) {
                                savedRanges.add(new IdRange(max));
                            }
                            SearchResUtil.saveSequenceSet(session, (IdRange[])savedRanges.toArray(IdRange[]::new));
                        }
                    }
                    response = new ESearchResponse(min, max, count, idRanges, uidRanges, highestModSeq, request.getTag(), useUids, resultOptions);
                } else {
                    SearchResUtil.saveSequenceSet(session, idRanges);
                    response = new SearchResponse(ids, highestModSeq);
                }
            }
            responder.respond(response);
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            this.okComplete(request, responder);
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Search failed in mailbox {} because of an invalid sequence-set ", (Object)session.getSelected().getMailboxId(), (Object)e);
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("Search failed in mailbox {}", (Object)session.getSelected().getMailboxId(), (Object)e);
            this.no(request, responder, HumanReadableText.SEARCH_FAILED);
            if (resultOptions.contains((Object)SearchResultOption.SAVE)) {
                SearchResUtil.resetSavedSequenceSet(session);
            }
        }
        finally {
            session.setAttribute(SEARCH_MODSEQ, null);
        }
    }

    private Collection<Long> asResults(ImapSession session, boolean useUids, Collection<MessageUid> uids) {
        if (useUids) {
            return (Collection)uids.stream().map(MessageUid::asLong).collect(Guavate.toImmutableList());
        }
        return (Collection)uids.stream().map(uid -> session.getSelected().msn((MessageUid)uid)).flatMap(Throwing.function(nullableMsn -> nullableMsn.fold(Stream::empty, msn -> Stream.of(Long.valueOf(Integer.valueOf(msn.asInt()).longValue()))))).collect(Guavate.toImmutableList());
    }

    private Collection<MessageUid> performUidSearch(MessageManager mailbox, SearchQuery query, MailboxSession msession) throws MailboxException {
        return (Collection)Flux.from((Publisher)mailbox.search(query, msession)).collect(Guavate.toImmutableList()).block();
    }

    private long[] toArray(Collection<Long> results) {
        return results.stream().mapToLong(x -> x).toArray();
    }

    private ModSeq findHighestModSeq(MailboxSession session, MessageManager mailbox, List<MessageRange> ranges, ModSeq currentHighest) throws MailboxException {
        ModSeq highestModSeq = null;
        int size = ranges.size();
        for (int i = size - 1; i > 0; --i) {
            Iterator results = Flux.from((Publisher)mailbox.listMessagesMetadata(ranges.get(i), session)).toStream().iterator();
            while (results.hasNext()) {
                ModSeq modSeq = ((ComposedMessageIdWithMetaData)results.next()).getModSeq();
                if (highestModSeq == null || modSeq.asLong() > highestModSeq.asLong()) {
                    highestModSeq = modSeq;
                }
                if (highestModSeq != currentHighest) continue;
                return highestModSeq;
            }
        }
        return highestModSeq;
    }

    private SearchQuery toQuery(SearchKey key, ImapSession session) throws MessageRangeException {
        SearchQuery.Criterion criterion = this.toCriterion(key, session);
        SearchQuery.Builder builder = SearchQuery.builder();
        SelectedMailbox selected = session.getSelected();
        if (selected != null) {
            builder.addRecentMessageUids(selected.getRecent());
        }
        return builder.andCriteria(new SearchQuery.Criterion[]{criterion}).build();
    }

    private SearchQuery.Criterion toCriterion(SearchKey key, ImapSession session) throws MessageRangeException {
        SearchKey.Type type = key.getType();
        DayMonthYear date = key.getDate();
        switch (type) {
            case TYPE_ALL: {
                return SearchQuery.all();
            }
            case TYPE_AND: {
                return this.and(key.getKeys(), session);
            }
            case TYPE_ANSWERED: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.ANSWERED);
            }
            case TYPE_BCC: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Bcc, (String)key.getValue());
            }
            case TYPE_BEFORE: {
                return SearchQuery.internalDateBefore((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_BODY: {
                return SearchQuery.bodyContains((String)key.getValue());
            }
            case TYPE_CC: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Cc, (String)key.getValue());
            }
            case TYPE_DELETED: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED);
            }
            case TYPE_DRAFT: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT);
            }
            case TYPE_FLAGGED: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.FLAGGED);
            }
            case TYPE_FROM: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)key.getValue());
            }
            case TYPE_HEADER: {
                String value = key.getValue();
                if (value == null || value.length() == 0) {
                    return SearchQuery.headerExists((String)key.getName());
                }
                return SearchQuery.headerContains((String)key.getName(), (String)value);
            }
            case TYPE_KEYWORD: {
                return SearchQuery.flagIsSet((String)key.getValue());
            }
            case TYPE_LARGER: {
                return SearchQuery.sizeGreaterThan((long)key.getSize());
            }
            case TYPE_NEW: {
                return SearchQuery.and((SearchQuery.Criterion)SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT), (SearchQuery.Criterion)SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN));
            }
            case TYPE_NOT: {
                return this.not(key.getKeys(), session);
            }
            case TYPE_OLD: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.RECENT);
            }
            case TYPE_ON: {
                return SearchQuery.internalDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_OR: {
                return this.or(key.getKeys(), session);
            }
            case TYPE_RECENT: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT);
            }
            case TYPE_SEEN: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN);
            }
            case TYPE_SENTBEFORE: {
                return SearchQuery.headerDateBefore((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_SENTON: {
                return SearchQuery.headerDateOn((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case TYPE_SENTSINCE: {
                SearchQuery.Criterion onCrit = SearchQuery.headerDateOn((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
                SearchQuery.Criterion afterCrit = SearchQuery.headerDateAfter((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
                return SearchQuery.or((SearchQuery.Criterion)onCrit, (SearchQuery.Criterion)afterCrit);
            }
            case TYPE_SEQUENCE_SET: {
                return this.sequence(key.getSequenceNumbers(), session);
            }
            case TYPE_SINCE: {
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
            }
            case TYPE_SMALLER: {
                return SearchQuery.sizeLessThan((long)key.getSize());
            }
            case TYPE_SUBJECT: {
                return SearchQuery.headerContains((String)"Subject", (String)key.getValue());
            }
            case TYPE_TEXT: {
                return SearchQuery.mailContains((String)key.getValue());
            }
            case TYPE_TO: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)key.getValue());
            }
            case TYPE_UID: {
                return this.uids(key.getUidRanges(), session);
            }
            case TYPE_UNANSWERED: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.ANSWERED);
            }
            case TYPE_UNDELETED: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DELETED);
            }
            case TYPE_UNDRAFT: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT);
            }
            case TYPE_UNFLAGGED: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.FLAGGED);
            }
            case TYPE_UNKEYWORD: {
                return SearchQuery.flagIsUnSet((String)key.getValue());
            }
            case TYPE_UNSEEN: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN);
            }
            case TYPE_OLDER: {
                Date withinDate = this.createWithinDate(key);
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)withinDate, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second), (SearchQuery.Criterion)SearchQuery.internalDateBefore((Date)withinDate, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
            }
            case TYPE_YOUNGER: {
                Date withinDate2 = this.createWithinDate(key);
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)withinDate2, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)withinDate2, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
            }
            case TYPE_MODSEQ: {
                session.setAttribute(SEARCH_MODSEQ, true);
                long modSeq = key.getModSeq();
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.modSeqEquals((long)modSeq), (SearchQuery.Criterion)SearchQuery.modSeqGreaterThan((long)modSeq));
            }
        }
        LOGGER.warn("Ignoring unknown search key {}", (Object)type);
        return SearchQuery.all();
    }

    private Date createWithinDate(SearchKey key) {
        long seconds = key.getSeconds();
        long res = System.currentTimeMillis() - seconds * 1000L;
        return new Date(res);
    }

    private SearchQuery.Criterion sequence(IdRange[] sequenceNumbers, ImapSession session) throws MessageRangeException {
        SelectedMailbox selected = session.getSelected();
        ArrayList<SearchQuery.UidRange> ranges = new ArrayList<SearchQuery.UidRange>();
        if (selected.existsCount() > 0L) {
            for (IdRange range : sequenceNumbers) {
                long lowVal = range.getLowVal();
                long highVal = range.getHighVal();
                if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
                    MessageUid highUid = selected.getLastUid().orElse(MessageUid.MIN_VALUE);
                    ranges.add(new SearchQuery.UidRange(highUid));
                    continue;
                }
                Optional<MessageUid> lowUid = lowVal != Long.MIN_VALUE ? selected.uid((int)lowVal) : selected.getFirstUid();
                if (!lowUid.isPresent()) continue;
                Optional<Object> highUid = Optional.empty();
                if (highVal != Long.MAX_VALUE) {
                    highUid = selected.uid((int)highVal);
                    if (!highUid.isPresent()) {
                        highUid = selected.getLastUid();
                    }
                } else {
                    highUid = selected.getLastUid();
                }
                ranges.add(new SearchQuery.UidRange(lowUid.orElse(MessageUid.MIN_VALUE), (MessageUid)highUid.orElse(MessageUid.MAX_VALUE)));
            }
        }
        return SearchQuery.uid((SearchQuery.UidRange[])((SearchQuery.UidRange[])ranges.toArray(SearchQuery.UidRange[]::new)));
    }

    private SearchQuery.Criterion uids(UidRange[] uids, ImapSession session) throws MessageRangeException {
        SelectedMailbox selected = session.getSelected();
        ArrayList<SearchQuery.UidRange> ranges = new ArrayList<SearchQuery.UidRange>();
        if (selected.existsCount() > 0L) {
            for (UidRange range : uids) {
                MessageUid lowVal = range.getLowVal();
                MessageUid highVal = range.getHighVal();
                if (lowVal.equals((Object)MessageUid.MAX_VALUE) && highVal.equals((Object)MessageUid.MAX_VALUE)) {
                    ranges.add(new SearchQuery.UidRange(selected.getLastUid().orElse(MessageUid.MIN_VALUE)));
                    continue;
                }
                if (highVal.equals((Object)MessageUid.MAX_VALUE) && selected.getLastUid().orElse(MessageUid.MIN_VALUE).compareTo(lowVal) < 0) {
                    ranges.add(new SearchQuery.UidRange(selected.getLastUid().orElse(MessageUid.MIN_VALUE)));
                    continue;
                }
                ranges.add(new SearchQuery.UidRange(lowVal, highVal));
            }
        }
        return SearchQuery.uid((SearchQuery.UidRange[])((SearchQuery.UidRange[])ranges.toArray(SearchQuery.UidRange[]::new)));
    }

    private SearchQuery.Criterion or(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        SearchKey keyOne = keys.get(0);
        SearchKey keyTwo = keys.get(1);
        SearchQuery.Criterion criterionOne = this.toCriterion(keyOne, session);
        SearchQuery.Criterion criterionTwo = this.toCriterion(keyTwo, session);
        return SearchQuery.or((SearchQuery.Criterion)criterionOne, (SearchQuery.Criterion)criterionTwo);
    }

    private SearchQuery.Criterion not(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        SearchKey key = keys.get(0);
        SearchQuery.Criterion criterion = this.toCriterion(key, session);
        return SearchQuery.not((SearchQuery.Criterion)criterion);
    }

    private SearchQuery.Criterion and(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        int size = keys.size();
        ArrayList<SearchQuery.Criterion> criteria = new ArrayList<SearchQuery.Criterion>(size);
        for (SearchKey key : keys) {
            SearchQuery.Criterion criterion = this.toCriterion(key, session);
            criteria.add(criterion);
        }
        return SearchQuery.and(criteria);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(SearchRequest request) {
        return MDCBuilder.create().addContext("action", (Object)"SEARCH").addContext("useUid", (Object)request.isUseUids()).addContext("searchOperation", (Object)request.getSearchOperation()).build();
    }
}

