/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;

public class FakeImapSession
implements ImapSession {
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private SelectedMailbox selectedMailbox = null;
    private final Map<String, Object> attributesByKey;
    private final ImapSession.SessionId sessionId = ImapSession.SessionId.generate();

    public FakeImapSession() {
        this.attributesByKey = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public ImapSession.SessionId sessionId() {
        return this.sessionId;
    }

    @Override
    public void logout() {
        this.closeMailbox();
        this.state = ImapSessionState.LOGOUT;
    }

    @Override
    public void authenticated() {
        this.state = ImapSessionState.AUTHENTICATED;
    }

    @Override
    public void deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        this.closeMailbox();
    }

    @Override
    public void selected(SelectedMailbox mailbox) {
        this.state = ImapSessionState.SELECTED;
        this.closeMailbox();
        this.selectedMailbox = mailbox;
    }

    @Override
    public SelectedMailbox getSelected() {
        return this.selectedMailbox;
    }

    @Override
    public ImapSessionState getState() {
        return this.state;
    }

    public void closeMailbox() {
        if (this.selectedMailbox != null) {
            this.selectedMailbox.deselect();
            this.selectedMailbox = null;
        }
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributesByKey.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributesByKey.remove(key);
        } else {
            this.attributesByKey.put(key, value);
        }
    }

    @Override
    public boolean startTLS() {
        return false;
    }

    @Override
    public boolean supportStartTLS() {
        return false;
    }

    @Override
    public boolean isCompressionSupported() {
        return false;
    }

    @Override
    public boolean startCompression() {
        return false;
    }

    @Override
    public void pushLineHandler(ImapLineHandler lineHandler) {
    }

    @Override
    public void popLineHandler() {
    }

    @Override
    public boolean isPlainAuthDisallowed() {
        return false;
    }

    @Override
    public boolean isTLSActive() {
        return false;
    }

    @Override
    public boolean supportMultipleNamespaces() {
        return false;
    }

    @Override
    public boolean isCompressionActive() {
        return false;
    }
}

