/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.stream.IntStream;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class MessageMetaDataUtils {
    public static MessageMetaData getMetaData(POP3Session session, int number) {
        return session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).filter(uidList -> number <= uidList.size()).map(uidList -> (MessageMetaData)uidList.get(number - 1)).orElse(null);
    }

    public static boolean isRFC1939Compatible(String uid) {
        if (uid == null) {
            return false;
        }
        return IntStream.range(0, uid.length()).allMatch(i -> uid.charAt(i) >= '!' && uid.charAt(i) <= '~');
    }
}

