/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imapserver.netty.ImapLineHandlerAdapter;
import org.apache.james.imapserver.netty.NettyConstants;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.jboss.netty.handler.codec.compression.ZlibWrapper;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyImapSession
implements ImapSession,
NettyConstants {
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private SelectedMailbox selectedMailbox;
    private final Map<String, Object> attributesByKey = new HashMap<String, Object>();
    private final SSLContext sslContext;
    private final String[] enabledCipherSuites;
    private final boolean compress;
    private final Channel channel;
    private int handlerCount;
    private final boolean plainAuthDisallowed;
    private final ImapSession.SessionId sessionId;

    public NettyImapSession(Channel channel, SSLContext sslContext, String[] enabledCipherSuites, boolean compress, boolean plainAuthDisallowed, ImapSession.SessionId sessionId) {
        this.channel = channel;
        this.sslContext = sslContext;
        this.enabledCipherSuites = enabledCipherSuites;
        this.compress = compress;
        this.plainAuthDisallowed = plainAuthDisallowed;
        this.sessionId = sessionId;
    }

    public ImapSession.SessionId sessionId() {
        return this.sessionId;
    }

    public void logout() {
        this.closeMailbox();
        this.state = ImapSessionState.LOGOUT;
    }

    public void authenticated() {
        this.state = ImapSessionState.AUTHENTICATED;
    }

    public void deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        this.closeMailbox();
    }

    public void selected(SelectedMailbox mailbox) {
        this.state = ImapSessionState.SELECTED;
        this.closeMailbox();
        this.selectedMailbox = mailbox;
    }

    public SelectedMailbox getSelected() {
        return this.selectedMailbox;
    }

    public ImapSessionState getState() {
        return this.state;
    }

    private void closeMailbox() {
        if (this.selectedMailbox != null) {
            this.selectedMailbox.deselect();
            this.selectedMailbox = null;
        }
    }

    public Object getAttribute(String key) {
        return this.attributesByKey.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributesByKey.remove(key);
        } else {
            this.attributesByKey.put(key, value);
        }
    }

    public boolean startTLS() {
        if (!this.supportStartTLS()) {
            return false;
        }
        this.channel.setReadable(false);
        SslHandler filter = new SslHandler(this.sslContext.createSSLEngine(), false);
        filter.getEngine().setUseClientMode(false);
        if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
            filter.getEngine().setEnabledCipherSuites(this.enabledCipherSuites);
        }
        this.channel.getPipeline().addFirst("sslHandler", (ChannelHandler)filter);
        this.channel.setReadable(true);
        return true;
    }

    public boolean supportStartTLS() {
        return this.sslContext != null;
    }

    public boolean isCompressionSupported() {
        return this.compress;
    }

    public boolean startCompression() {
        if (!this.isCompressionSupported()) {
            return false;
        }
        this.channel.setReadable(false);
        ZlibDecoder decoder = new ZlibDecoder(ZlibWrapper.NONE);
        ZlibEncoder encoder = new ZlibEncoder(ZlibWrapper.NONE, 5);
        if (this.channel.getPipeline().get("sslHandler") == null) {
            this.channel.getPipeline().addFirst("zlibDecoder", (ChannelHandler)decoder);
            this.channel.getPipeline().addFirst("zlibEncoder", (ChannelHandler)encoder);
        } else {
            this.channel.getPipeline().addAfter("sslHandler", "zlibDecoder", (ChannelHandler)decoder);
            this.channel.getPipeline().addAfter("sslHandler", "zlibEncoder", (ChannelHandler)encoder);
        }
        this.channel.setReadable(true);
        return true;
    }

    public void pushLineHandler(ImapLineHandler lineHandler) {
        this.channel.setReadable(false);
        this.channel.getPipeline().addBefore("requestDecoder", "lineHandler" + this.handlerCount++, (ChannelHandler)new ImapLineHandlerAdapter(this, lineHandler));
        this.channel.setReadable(true);
    }

    public void popLineHandler() {
        this.channel.setReadable(false);
        this.channel.getPipeline().remove("lineHandler" + --this.handlerCount);
        this.channel.setReadable(true);
    }

    public boolean isPlainAuthDisallowed() {
        return this.plainAuthDisallowed;
    }

    public boolean isTLSActive() {
        return this.channel.getPipeline().get("sslHandler") != null;
    }

    public boolean supportMultipleNamespaces() {
        return false;
    }

    public boolean isCompressionActive() {
        return this.channel.getPipeline().get("zlibDecoder") != null;
    }
}

