/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.api;

import java.util.function.Supplier;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.TimeMetric;
import org.reactivestreams.Publisher;

public interface MetricFactory {
    public Metric generate(String var1);

    public TimeMetric timer(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T decorateSupplierWithTimerMetric(String name, Supplier<T> operation) {
        TimeMetric timer = this.timer(name);
        try {
            T t = operation.get();
            return t;
        }
        finally {
            timer.stopAndPublish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T decorateSupplierWithTimerMetricLogP99(String name, Supplier<T> operation) {
        TimeMetric timer = this.timer(name);
        try {
            T t = operation.get();
            return t;
        }
        finally {
            timer.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD);
        }
    }

    public <T> Publisher<T> decoratePublisherWithTimerMetric(String var1, Publisher<T> var2);

    public <T> Publisher<T> decoratePublisherWithTimerMetricLogP99(String var1, Publisher<T> var2);

    default public void runPublishingTimerMetric(String name, Runnable runnable) {
        this.decorateSupplierWithTimerMetric(name, () -> {
            runnable.run();
            return null;
        });
    }
}

