/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.io.Serializable;
import java.util.Date;
import org.apache.openjpa.jdbc.kernel.exps.Abs;
import org.apache.openjpa.jdbc.kernel.exps.Aggregate;
import org.apache.openjpa.jdbc.kernel.exps.All;
import org.apache.openjpa.jdbc.kernel.exps.AndExpression;
import org.apache.openjpa.jdbc.kernel.exps.Any;
import org.apache.openjpa.jdbc.kernel.exps.Args;
import org.apache.openjpa.jdbc.kernel.exps.Avg;
import org.apache.openjpa.jdbc.kernel.exps.BindVariableAndExpression;
import org.apache.openjpa.jdbc.kernel.exps.BindVariableExpression;
import org.apache.openjpa.jdbc.kernel.exps.CoalesceExpression;
import org.apache.openjpa.jdbc.kernel.exps.CollectionParam;
import org.apache.openjpa.jdbc.kernel.exps.CompareExpression;
import org.apache.openjpa.jdbc.kernel.exps.Concat;
import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ConstGetObjectId;
import org.apache.openjpa.jdbc.kernel.exps.ConstInstanceofExpression;
import org.apache.openjpa.jdbc.kernel.exps.ConstPath;
import org.apache.openjpa.jdbc.kernel.exps.ContainsExpression;
import org.apache.openjpa.jdbc.kernel.exps.ContainsKeyExpression;
import org.apache.openjpa.jdbc.kernel.exps.Count;
import org.apache.openjpa.jdbc.kernel.exps.CurrentDate;
import org.apache.openjpa.jdbc.kernel.exps.DatastoreFunction;
import org.apache.openjpa.jdbc.kernel.exps.Distinct;
import org.apache.openjpa.jdbc.kernel.exps.EmptyExpression;
import org.apache.openjpa.jdbc.kernel.exps.EndsWithExpression;
import org.apache.openjpa.jdbc.kernel.exps.EqualExpression;
import org.apache.openjpa.jdbc.kernel.exps.EqualTypeExpression;
import org.apache.openjpa.jdbc.kernel.exps.Exp;
import org.apache.openjpa.jdbc.kernel.exps.Extension;
import org.apache.openjpa.jdbc.kernel.exps.GeneralCaseExpression;
import org.apache.openjpa.jdbc.kernel.exps.GetMapValue;
import org.apache.openjpa.jdbc.kernel.exps.GetObjectId;
import org.apache.openjpa.jdbc.kernel.exps.HasContainsExpressionVisitor;
import org.apache.openjpa.jdbc.kernel.exps.InExpression;
import org.apache.openjpa.jdbc.kernel.exps.InKeyExpression;
import org.apache.openjpa.jdbc.kernel.exps.InSubQExpression;
import org.apache.openjpa.jdbc.kernel.exps.InValueExpression;
import org.apache.openjpa.jdbc.kernel.exps.Index;
import org.apache.openjpa.jdbc.kernel.exps.IndexOf;
import org.apache.openjpa.jdbc.kernel.exps.InstanceofExpression;
import org.apache.openjpa.jdbc.kernel.exps.IsEmptyExpression;
import org.apache.openjpa.jdbc.kernel.exps.IsNotEmptyExpression;
import org.apache.openjpa.jdbc.kernel.exps.JDBCAggregateListener;
import org.apache.openjpa.jdbc.kernel.exps.JDBCFilterListener;
import org.apache.openjpa.jdbc.kernel.exps.Lit;
import org.apache.openjpa.jdbc.kernel.exps.MapEntry;
import org.apache.openjpa.jdbc.kernel.exps.MapKey;
import org.apache.openjpa.jdbc.kernel.exps.MatchesExpression;
import org.apache.openjpa.jdbc.kernel.exps.Math;
import org.apache.openjpa.jdbc.kernel.exps.Max;
import org.apache.openjpa.jdbc.kernel.exps.Min;
import org.apache.openjpa.jdbc.kernel.exps.NotContainsExpression;
import org.apache.openjpa.jdbc.kernel.exps.NotEqualExpression;
import org.apache.openjpa.jdbc.kernel.exps.NotEqualTypeExpression;
import org.apache.openjpa.jdbc.kernel.exps.NotExpression;
import org.apache.openjpa.jdbc.kernel.exps.Null;
import org.apache.openjpa.jdbc.kernel.exps.NullIfExpression;
import org.apache.openjpa.jdbc.kernel.exps.OrExpression;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.Param;
import org.apache.openjpa.jdbc.kernel.exps.SelectConstructor;
import org.apache.openjpa.jdbc.kernel.exps.SimpleCaseExpression;
import org.apache.openjpa.jdbc.kernel.exps.Size;
import org.apache.openjpa.jdbc.kernel.exps.Sqrt;
import org.apache.openjpa.jdbc.kernel.exps.StartsWithExpression;
import org.apache.openjpa.jdbc.kernel.exps.StringLength;
import org.apache.openjpa.jdbc.kernel.exps.SubQ;
import org.apache.openjpa.jdbc.kernel.exps.Substring;
import org.apache.openjpa.jdbc.kernel.exps.Sum;
import org.apache.openjpa.jdbc.kernel.exps.ToLowerCase;
import org.apache.openjpa.jdbc.kernel.exps.ToUpperCase;
import org.apache.openjpa.jdbc.kernel.exps.Trim;
import org.apache.openjpa.jdbc.kernel.exps.Type;
import org.apache.openjpa.jdbc.kernel.exps.TypeLit;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.kernel.exps.Variable;
import org.apache.openjpa.jdbc.kernel.exps.WhenCondition;
import org.apache.openjpa.jdbc.kernel.exps.WhenScalar;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.Arguments;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.UserException;

public class JDBCExpressionFactory
implements ExpressionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Val NULL = new Null();
    private static final Localizer _loc = Localizer.forPackage(JDBCExpressionFactory.class);
    private final ClassMapping _type;
    private final SelectConstructor _cons = new SelectConstructor();
    private int _getMapValueAlias = 0;
    private boolean _isBooleanLiteralAsNumeric = true;

    public JDBCExpressionFactory(ClassMapping type) {
        this._type = type;
    }

    public void setBooleanLiteralAsNumeric(boolean isBooleanLiteralAsNumeric) {
        this._isBooleanLiteralAsNumeric = isBooleanLiteralAsNumeric;
    }

    public SelectConstructor getSelectConstructor() {
        return this._cons;
    }

    @Override
    public Expression emptyExpression() {
        return new EmptyExpression();
    }

    @Override
    public Expression asExpression(Value v) {
        return this.equal(v, this.newLiteral(Boolean.TRUE, 2));
    }

    @Override
    public Expression equal(Value v1, Value v2) {
        if (v1 instanceof PCPath && ((PCPath)v1).isUnaccessedVariable()) {
            return this.contains(v1, v2);
        }
        if (v2 instanceof PCPath && ((PCPath)v2).isUnaccessedVariable()) {
            return this.contains(v2, v1);
        }
        if (v1 instanceof Type || v2 instanceof Type) {
            Value val = v1 instanceof Type ? v1 : v2;
            this.verifyTypeOperation(val, null, false);
            return new EqualTypeExpression((Val)v1, (Val)v2);
        }
        return new EqualExpression((Val)v1, (Val)v2);
    }

    private void verifyTypeOperation(Value val, Value param, boolean isNotEqual) {
        if (val.getPath() == null) {
            return;
        }
        PCPath path = (PCPath)val.getPath();
        Discriminator disc = ((Type)val).getDiscriminator();
        if (disc == null || val.getMetaData().getPCSuperclass() == null && val.getMetaData().getPCSubclasses().length <= 0) {
            throw new UserException(_loc.get("invalid-type-argument", path.last() != null ? path.getPCPathString() : path.getSchemaAlias()));
        }
        if (disc.getColumns().length == 0) {
            if (disc.getStrategy() instanceof NoneDiscriminatorStrategy) {
                if (path.last() != null) {
                    throw new UserException(_loc.get("type-argument-unsupported", path.last().getName()));
                }
                if (isNotEqual) {
                    if (param != null && param instanceof Null) {
                        throw new UserException(_loc.get("type-in-expression-unsupported", path.getSchemaAlias()));
                    }
                    throw new UserException(_loc.get("type-not-equal-unsupported", path.getSchemaAlias()));
                }
            }
            if (param != null && param instanceof CollectionParam) {
                throw new UserException(_loc.get("collection-param-unsupported"));
            }
        }
    }

    @Override
    public Expression notEqual(Value v1, Value v2) {
        if (v1 instanceof Type || v2 instanceof Type) {
            Value val;
            Value value = val = v1 instanceof Type ? v1 : v2;
            Value param = val == v1 ? (v2 instanceof Null ? v2 : null) : (v1 instanceof Null ? v1 : null);
            this.verifyTypeOperation(val, param, true);
            return new NotEqualTypeExpression((Val)v1, (Val)v2);
        }
        return new NotEqualExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression lessThan(Value v1, Value v2) {
        return new CompareExpression((Val)v1, (Val)v2, "<");
    }

    @Override
    public Expression greaterThan(Value v1, Value v2) {
        return new CompareExpression((Val)v1, (Val)v2, ">");
    }

    @Override
    public Expression lessThanEqual(Value v1, Value v2) {
        return new CompareExpression((Val)v1, (Val)v2, "<=");
    }

    @Override
    public Expression greaterThanEqual(Value v1, Value v2) {
        return new CompareExpression((Val)v1, (Val)v2, ">=");
    }

    @Override
    public Expression isEmpty(Value val) {
        return new IsEmptyExpression((Val)val);
    }

    @Override
    public Expression isNotEmpty(Value val) {
        return new IsNotEmptyExpression((Val)val);
    }

    @Override
    public Expression contains(Value map, Value arg) {
        if (map instanceof Const) {
            if (arg instanceof Type) {
                this.verifyTypeOperation(arg, map, false);
                if (((ClassMapping)arg.getMetaData()).getDiscriminator().getColumns().length == 0) {
                    return new EqualTypeExpression((Val)arg, (Val)map);
                }
            }
            return new InExpression((Val)arg, (Const)map);
        }
        if (map instanceof SubQ) {
            return new InSubQExpression((Val)arg, (SubQ)map);
        }
        return new ContainsExpression((Val)map, (Val)arg);
    }

    @Override
    public Expression containsKey(Value map, Value arg) {
        if (map instanceof Const) {
            return new InKeyExpression((Val)arg, (Const)map);
        }
        return new ContainsKeyExpression((Val)map, (Val)arg);
    }

    @Override
    public Expression containsValue(Value map, Value arg) {
        if (map instanceof Const) {
            return new InValueExpression((Val)arg, (Const)map);
        }
        return new ContainsExpression((Val)map, (Val)arg);
    }

    @Override
    public Expression isInstance(Value val, Class c) {
        if (val instanceof Const) {
            return new ConstInstanceofExpression((Const)val, c);
        }
        return new InstanceofExpression((PCPath)val, c);
    }

    @Override
    public Expression and(Expression exp1, Expression exp2) {
        if (exp1 instanceof BindVariableExpression) {
            return new BindVariableAndExpression((BindVariableExpression)exp1, (Exp)exp2);
        }
        if (exp2 instanceof BindVariableExpression) {
            return new BindVariableAndExpression((BindVariableExpression)exp2, (Exp)exp1);
        }
        return new AndExpression((Exp)exp1, (Exp)exp2);
    }

    @Override
    public Expression or(Expression exp1, Expression exp2) {
        return new OrExpression((Exp)exp1, (Exp)exp2);
    }

    @Override
    public Expression not(Expression exp) {
        if (!(exp instanceof IsNotEmptyExpression) && !(exp instanceof InSubQExpression) && HasContainsExpressionVisitor.hasContains(exp)) {
            return new NotContainsExpression((Exp)exp);
        }
        return new NotExpression((Exp)exp);
    }

    @Override
    public Expression bindVariable(Value var, Value val) {
        if (val instanceof Const) {
            PCPath path = new PCPath(this._type, (Variable)var);
            path.setMetaData(var.getMetaData());
            return new InExpression(path, (Const)val);
        }
        return new BindVariableExpression((Variable)var, (PCPath)val, false);
    }

    @Override
    public Expression bindKeyVariable(Value var, Value val) {
        if (val instanceof Const) {
            PCPath path = new PCPath(this._type, (Variable)var);
            path.setMetaData(var.getMetaData());
            return new InKeyExpression(path, (Const)val);
        }
        return new BindVariableExpression((Variable)var, (PCPath)val, true);
    }

    @Override
    public Expression bindValueVariable(Value var, Value val) {
        return this.bindVariable(var, val);
    }

    @Override
    public Expression startsWith(Value v1, Value v2) {
        return new StartsWithExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression endsWith(Value v1, Value v2) {
        return new EndsWithExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression notMatches(Value v1, Value v2, String single, String multi, String esc) {
        return this.not(this.matches(v1, v2, single, multi, esc));
    }

    @Override
    public Expression matches(Value v1, Value v2, String single, String multi, String esc) {
        if (!(v2 instanceof Const)) {
            throw new UserException(_loc.get("const-only", "matches"));
        }
        if (esc == null && this._type.getMappingRepository().getDBDictionary().requiresSearchStringEscapeForLike) {
            esc = this._type.getMappingRepository().getDBDictionary().searchStringEscape;
        }
        return new MatchesExpression((Val)v1, (Const)v2, single, multi, esc);
    }

    @Override
    public Subquery newSubquery(ClassMetaData candidate, boolean subs, String alias) {
        DBDictionary dict = this._type.getMappingRepository().getDBDictionary();
        dict.assertSupport(dict.supportsSubselect, "SupportsSubselect");
        return new SubQ((ClassMapping)candidate, subs, alias);
    }

    @Override
    public Path newPath() {
        return new PCPath(this._type);
    }

    @Override
    public Path newPath(Value val) {
        if (val instanceof Const) {
            return new ConstPath((Const)val);
        }
        if (val instanceof SubQ) {
            return new PCPath((SubQ)val);
        }
        return new PCPath(this._type, (Variable)val);
    }

    @Override
    public Literal newLiteral(Object val, int ptype) {
        return new Lit(val, ptype);
    }

    @Override
    public Literal newTypeLiteral(Object val, int ptype) {
        return new TypeLit(val, ptype);
    }

    @Override
    public Value getThis() {
        return new PCPath(this._type);
    }

    @Override
    public Value getNull() {
        return NULL;
    }

    @Override
    public <T extends Date> Value getCurrentDate(Class<T> dateType) {
        return new CurrentDate(dateType);
    }

    @Override
    public <T extends Date> Value getCurrentTime(Class<T> dateType) {
        return new CurrentDate(dateType);
    }

    @Override
    public <T extends Date> Value getCurrentTimestamp(Class<T> dateType) {
        return new CurrentDate(dateType);
    }

    @Override
    public Parameter newParameter(Object name, Class type) {
        return new Param(name, type);
    }

    @Override
    public Parameter newCollectionValuedParameter(Object key, Class type) {
        return new CollectionParam(key, type);
    }

    @Override
    public Value newExtension(FilterListener listener, Value target, Value arg) {
        return new Extension((JDBCFilterListener)listener, (Val)target, (Val)arg, this._type);
    }

    @Override
    public Value newAggregate(AggregateListener listener, Value arg) {
        return new Aggregate((JDBCAggregateListener)listener, (Val)arg, this._type);
    }

    @Override
    public Arguments newArgumentList(Value v1, Value v2) {
        return new Args((Val)v1, (Val)v2);
    }

    @Override
    public Arguments newArgumentList(Value ... vs) {
        if (vs == null) {
            return new Args(null);
        }
        Val[] vals = new Val[vs.length];
        int i = 0;
        for (Value v : vs) {
            vals[i++] = (Val)v;
        }
        return new Args(vals);
    }

    @Override
    public Value newUnboundVariable(String name, Class type) {
        return new Variable(name, type);
    }

    @Override
    public Value newBoundVariable(String name, Class type) {
        return this.newUnboundVariable(name, type);
    }

    @Override
    public Value cast(Value val, Class cls) {
        val.setImplicitType(cls);
        return val;
    }

    @Override
    public Value add(Value v1, Value v2) {
        return new Math((Val)v1, (Val)v2, "+");
    }

    @Override
    public Value subtract(Value v1, Value v2) {
        return new Math((Val)v1, (Val)v2, "-");
    }

    @Override
    public Value multiply(Value v1, Value v2) {
        return new Math((Val)v1, (Val)v2, "*");
    }

    @Override
    public Value divide(Value v1, Value v2) {
        return new Math((Val)v1, (Val)v2, "/");
    }

    @Override
    public Value mod(Value v1, Value v2) {
        return new Math((Val)v1, (Val)v2, "MOD");
    }

    @Override
    public Value abs(Value val) {
        return new Abs((Val)val);
    }

    @Override
    public Value indexOf(Value v1, Value v2) {
        return new IndexOf((Val)v1, (Val)v2);
    }

    @Override
    public Value concat(Value v1, Value v2) {
        return new Concat((Val)v1, (Val)v2);
    }

    @Override
    public Value stringLength(Value str) {
        return new StringLength((Val)str);
    }

    @Override
    public Value trim(Value str, Value trimChar, Boolean where) {
        return new Trim((Val)str, (Val)trimChar, where);
    }

    @Override
    public Value sqrt(Value val) {
        return new Sqrt((Val)val);
    }

    @Override
    public Value substring(Value v1, Value v2) {
        return new Substring((Val)v1, (Val)v2);
    }

    @Override
    public Value toUpperCase(Value val) {
        return new ToUpperCase((Val)val);
    }

    @Override
    public Value toLowerCase(Value val) {
        return new ToLowerCase((Val)val);
    }

    @Override
    public Value avg(Value val) {
        return new Avg((Val)val);
    }

    @Override
    public Value count(Value val) {
        return new Count((Val)val);
    }

    @Override
    public Value distinct(Value val) {
        return new Distinct((Val)val);
    }

    @Override
    public Value max(Value val) {
        return new Max((Val)val);
    }

    @Override
    public Value min(Value val) {
        return new Min((Val)val);
    }

    @Override
    public Value sum(Value val) {
        return new Sum((Val)val);
    }

    @Override
    public Value any(Value val) {
        return new Any((Val)val);
    }

    @Override
    public Value all(Value val) {
        return new All((Val)val);
    }

    @Override
    public Value size(Value val) {
        return new Size((Val)val);
    }

    @Override
    public Value index(Value val) {
        ((PCPath)val).verifyIndexedField();
        return new Index((Val)val);
    }

    @Override
    public Value type(Value val) {
        return new Type((Val)val);
    }

    @Override
    public Value mapEntry(Value key, Value val) {
        return new MapEntry((Val)key, (Val)val);
    }

    @Override
    public Value mapKey(Value key, Value val) {
        return new MapKey((Val)key);
    }

    @Override
    public Value getKey(Value val) {
        ((PCPath)val).getKey();
        return val;
    }

    @Override
    public Value getObjectId(Value val) {
        if (val instanceof Const) {
            return new ConstGetObjectId((Const)val);
        }
        return new GetObjectId((PCPath)val);
    }

    @Override
    public Value getMapValue(Value map, Value arg) {
        return new GetMapValue((Val)map, (Val)arg, "gmv" + this._getMapValueAlias++);
    }

    private Value getLiteralRawString(Value val) {
        if (val instanceof Lit) {
            Lit lit = (Lit)val;
            StringBuilder value = new StringBuilder();
            int pType = lit.getParseType();
            if (pType == 4 || pType == 3) {
                value.append("'").append(lit.getValue().toString()).append("'");
            } else if (pType == 2) {
                Boolean boolVal = (Boolean)lit.getValue();
                if (this._isBooleanLiteralAsNumeric) {
                    value.append(boolVal != false ? "1" : "0");
                } else {
                    value.append(boolVal != false ? "true" : "false");
                }
            } else {
                if (pType == 6) {
                    lit.setRaw(true);
                    return val;
                }
                value.append(lit.getValue().toString());
            }
            lit.setValue(new Raw(value.toString()));
            return lit;
        }
        return val;
    }

    @Override
    public Value simpleCaseExpression(Value caseOperand, Expression[] exp, Value val1) {
        Exp[] exps = new Exp[exp.length];
        for (int i = 0; i < exp.length; ++i) {
            exps[i] = (Exp)exp[i];
        }
        val1 = this.getLiteralRawString(val1);
        return new SimpleCaseExpression((Val)caseOperand, exps, (Val)val1);
    }

    @Override
    public Value generalCaseExpression(Expression[] exp, Value val) {
        Exp[] exps = new Exp[exp.length];
        for (int i = 0; i < exp.length; ++i) {
            exps[i] = (Exp)exp[i];
        }
        val = this.getLiteralRawString(val);
        return new GeneralCaseExpression(exps, (Val)val);
    }

    @Override
    public Expression whenCondition(Expression exp, Value val) {
        val = this.getLiteralRawString(val);
        return new WhenCondition((Exp)exp, (Val)val);
    }

    @Override
    public Expression whenScalar(Value val1, Value val2) {
        val1 = this.getLiteralRawString(val1);
        val2 = this.getLiteralRawString(val2);
        return new WhenScalar((Val)val1, (Val)val2);
    }

    @Override
    public Value coalesceExpression(Value[] vals) {
        Val[] values = new Val[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            values[i] = this.getLiteralRawString(vals[i]);
        }
        return new CoalesceExpression(values);
    }

    @Override
    public Value nullIfExpression(Value val1, Value val2) {
        val1 = this.getLiteralRawString(val1);
        val2 = this.getLiteralRawString(val2);
        return new NullIfExpression((Val)val1, (Val)val2);
    }

    @Override
    public Value newFunction(String functionName, Class<?> resultType, Value ... args) {
        return new DatastoreFunction(functionName, resultType, this.newArgumentList(args));
    }

    @Override
    public boolean isVerticalType(Value val) {
        if (!(val instanceof Type)) {
            return false;
        }
        ClassMapping cm = (ClassMapping)((Type)val).getMetaData();
        String strat = cm.getMappingInfo().getHierarchyStrategy();
        return strat != null && strat.equals("vertical");
    }
}

