/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.3.0", scheme="dataset-test", title="DataSet Test", syntax="dataset-test:name", producerOnly=true, label="core,testing", lenientProperties=true)
public class DataSetTestEndpoint
extends MockEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DataSetTestEndpoint.class);
    private Endpoint expectedMessageEndpoint;
    @UriPath(description="Name of endpoint to lookup in the registry to use for polling messages used for testing")
    @Metadata(required=true)
    private String name;
    @UriParam
    private boolean anyOrder;
    @UriParam(defaultValue="2000", javaType="java.time.Duration")
    private long timeout = 2000L;
    @UriParam
    private boolean split;
    @UriParam
    private String delimiter = "\\n|\\r";

    public DataSetTestEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public void setExpectedMessageEndpoint(Endpoint expectedMessageEndpoint) {
        this.expectedMessageEndpoint = expectedMessageEndpoint;
    }

    protected void doStart() throws Exception {
        LOG.debug("Consuming expected messages from: {}", (Object)this.expectedMessageEndpoint);
        final ArrayList expectedBodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.expectedMessageEndpoint, (Processor)new Processor(){

            public void process(Exchange exchange) throws Exception {
                Object body = DataSetTestEndpoint.this.getInBody(exchange);
                if (body instanceof WrappedFile) {
                    body = exchange.getIn().getBody(String.class);
                }
                if (DataSetTestEndpoint.this.split) {
                    Iterator it = ObjectHelper.createIterator((Object)body, (String)DataSetTestEndpoint.this.delimiter, (boolean)false, (boolean)true);
                    while (it.hasNext()) {
                        Object line = it.next();
                        LOG.trace("Received message body {}", line);
                        expectedBodies.add(line);
                    }
                } else {
                    expectedBodies.add(body);
                }
            }
        }, (long)this.timeout);
        LOG.info("Received: {} expected message(s) from: {}", (Object)expectedBodies.size(), (Object)this.expectedMessageEndpoint);
        if (this.anyOrder) {
            this.expectedBodiesReceivedInAnyOrder(expectedBodies);
        } else {
            this.expectedBodiesReceived(expectedBodies);
        }
    }

    protected Object getInBody(Exchange exchange) {
        return exchange.getIn().getBody();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAnyOrder() {
        return this.anyOrder;
    }

    public void setAnyOrder(boolean anyOrder) {
        this.anyOrder = anyOrder;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

