/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.filesystem.ResourceFactory;

public class FileSystemImpl
implements FileSystem {
    private final JamesDirectoriesProvider directoryProvider;
    private final ResourceFactory resourceLoader;

    public FileSystemImpl(JamesDirectoriesProvider directoryProvider) {
        this.directoryProvider = directoryProvider;
        this.resourceLoader = new ResourceFactory(directoryProvider);
    }

    public File getBasedir() throws FileNotFoundException {
        return new File(this.directoryProvider.getRootDirectory());
    }

    public InputStream getResource(String url) throws IOException {
        return this.resourceLoader.getResource(url).getInputStream();
    }

    public File getFile(String fileURL) throws FileNotFoundException {
        try {
            return this.resourceLoader.getResource(fileURL).getFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }
}

