/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.maildir;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.mailbox.model.MailboxId;

public class MaildirId
implements MailboxId,
Serializable {
    private final UUID id;

    public static MaildirId random() {
        return MaildirId.of(UUID.randomUUID());
    }

    public static MaildirId of(UUID id) {
        return new MaildirId(id);
    }

    public static MaildirId fromString(String serialized) {
        return MaildirId.of(UUID.fromString(serialized));
    }

    private MaildirId(UUID id) {
        this.id = id;
    }

    public String serialize() {
        return this.id.toString();
    }

    public String toString() {
        return this.id.toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof MaildirId) {
            MaildirId maildirId = (MaildirId)o;
            return Objects.equals(this.id, maildirId.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }

    public static class Factory
    implements MailboxId.Factory {
        public MaildirId fromString(String serialized) {
            return MaildirId.fromString(serialized);
        }
    }
}

