/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.steveash.guavate.Guavate;
import java.util.Collection;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class PostmasterAlias
extends GenericMailet {
    public void service(Mail mail) throws MessagingException {
        Collection postmasterAliases = (Collection)mail.getRecipients().stream().filter(this::isPostmasterAlias).collect(Guavate.toImmutableList());
        if (!postmasterAliases.isEmpty()) {
            mail.setRecipients((Collection)Stream.concat(mail.getRecipients().stream().filter(address -> !postmasterAliases.contains(address)), Stream.of(this.getMailetContext().getPostmaster())).collect(Guavate.toImmutableSet()));
        }
    }

    private boolean isPostmasterAlias(MailAddress addr) {
        return addr.getLocalPart().equalsIgnoreCase("postmaster") && this.getMailetContext().isLocalServer(addr.getDomain()) && !this.getMailetContext().isLocalEmail(addr);
    }

    public String getMailetInfo() {
        return "Postmaster aliasing mailet";
    }
}

