/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.mailbox.model.MessageIdDto;
import org.apache.james.util.streams.Iterators;
import org.apache.mailet.ArbitrarySerializable;
import org.apache.mailet.AttributeValue;
import org.nustaq.serialization.FSTConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Serializer<T> {
    public static final Serializer<Boolean> BOOLEAN_SERIALIZER = new BooleanSerializer();
    public static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    public static final Serializer<Integer> INT_SERIALIZER = new IntSerializer();
    public static final Serializer<Long> LONG_SERIALIZER = new LongSerializer();
    public static final Serializer<Float> FLOAT_SERIALIZER = new FloatSerializer();
    public static final Serializer<Double> DOUBLE_SERIALIZER = new DoubleSerializer();
    public static final Serializer<ZonedDateTime> DATE_SERIALIZER = new DateSerializer();
    public static final Serializer<MessageIdDto> MESSAGE_ID_DTO_SERIALIZER = new MessageIdDtoSerializer();
    public static final Serializer<URL> URL_SERIALIZER = new UrlSerializer();

    public JsonNode serialize(T var1);

    public Optional<T> deserialize(JsonNode var1);

    public String getName();

    public static class FSTSerializer
    implements Serializer<Serializable> {
        static final FSTConfiguration CONFIGURATION = FSTConfiguration.createJsonConfiguration();

        @Override
        public JsonNode serialize(Serializable object) {
            String json = CONFIGURATION.asJsonString((Object)object);
            try {
                return new ObjectMapper().reader().readTree(json);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Optional<Serializable> deserialize(JsonNode json) {
            try {
                return Optional.of((Serializable)CONFIGURATION.asObject(new ObjectMapper().writer().writeValueAsBytes((Object)json)));
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        }

        @Override
        public String getName() {
            return "FSTSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class OptionalSerializer<U>
    implements Serializer<Optional<AttributeValue<U>>> {
        @Override
        public JsonNode serialize(Optional<AttributeValue<U>> object) {
            return object.map(AttributeValue::toJson).orElse((JsonNode)NullNode.getInstance());
        }

        @Override
        public Optional<Optional<AttributeValue<U>>> deserialize(JsonNode json) {
            if (json instanceof ObjectNode) {
                AttributeValue<?> value = AttributeValue.fromJson(json);
                return Optional.of(Optional.of(value));
            }
            if (json instanceof NullNode) {
                return Optional.of(Optional.empty());
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "OptionalSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class MapSerializer<U>
    implements Serializer<Map<String, AttributeValue<U>>> {
        @Override
        public JsonNode serialize(Map<String, AttributeValue<U>> object) {
            Map jsonMap = (Map)object.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((AttributeValue)entry.getValue()).toJson()));
            return new ObjectNode(JsonNodeFactory.instance, jsonMap);
        }

        @Override
        public Optional<Map<String, AttributeValue<U>>> deserialize(JsonNode json) {
            if (json instanceof ObjectNode) {
                return Optional.of((Map)Iterators.toStream((Iterator)json.fields()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> AttributeValue.fromJson((JsonNode)entry.getValue()))));
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "MapSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class CollectionSerializer<U>
    implements Serializer<Collection<AttributeValue<U>>> {
        @Override
        public JsonNode serialize(Collection<AttributeValue<U>> object) {
            List jsons = (List)object.stream().map(AttributeValue::toJson).collect(ImmutableList.toImmutableList());
            return new ArrayNode(JsonNodeFactory.instance, jsons);
        }

        @Override
        public Optional<Collection<AttributeValue<U>>> deserialize(JsonNode json) {
            if (json instanceof ArrayNode) {
                return Optional.of((Collection)Iterators.toStream((Iterator)json.elements()).map(value -> AttributeValue.fromJson(value)).collect(ImmutableList.toImmutableList()));
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "CollectionSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class UrlSerializer
    implements Serializer<URL> {
        @Override
        public JsonNode serialize(URL object) {
            return STRING_SERIALIZER.serialize(object.toString());
        }

        @Override
        public Optional<URL> deserialize(JsonNode json) {
            return STRING_SERIALIZER.deserialize(json).flatMap(url -> {
                try {
                    return Optional.of(new URL((String)url));
                }
                catch (MalformedURLException e) {
                    return Optional.empty();
                }
            });
        }

        @Override
        public String getName() {
            return "UrlSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class ArbitrarySerializableSerializer<T extends ArbitrarySerializable<T>>
    implements Serializer<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ArbitrarySerializableSerializer.class);

        @Override
        public JsonNode serialize(T serializable) {
            ArbitrarySerializable.Serializable serialized = serializable.serialize();
            ObjectNode serializedJson = JsonNodeFactory.instance.objectNode();
            serializedJson.put("deserializer", serialized.getDeserializer().getName());
            serializedJson.replace("value", serialized.getValue().toJson());
            return serializedJson;
        }

        @Override
        public Optional<T> deserialize(JsonNode json) {
            return Optional.of(json).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).flatMap(this::instantiate);
        }

        public Optional<T> instantiate(ObjectNode fields) {
            return Optional.ofNullable(fields.get("deserializer")).flatMap(serializer -> Optional.ofNullable(fields.get("value")).flatMap(value -> this.deserialize(serializer.asText(), AttributeValue.fromJson(value))));
        }

        private Optional<T> deserialize(String serializer, AttributeValue<?> value) {
            try {
                Class<?> deserializerClass = Class.forName(serializer);
                if (ArbitrarySerializable.Deserializer.class.isAssignableFrom(deserializerClass)) {
                    ArbitrarySerializable.Deserializer deserializer = (ArbitrarySerializable.Deserializer)deserializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    return deserializer.deserialize(new ArbitrarySerializable.Serializable(value, deserializerClass));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while deserializing using serializer {} and value {}", new Object[]{serializer, value, e});
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "ArbitrarySerializableSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class MessageIdDtoSerializer
    implements Serializer<MessageIdDto> {
        @Override
        public JsonNode serialize(MessageIdDto serializable) {
            return STRING_SERIALIZER.serialize(serializable.asString());
        }

        @Override
        public Optional<MessageIdDto> deserialize(JsonNode json) {
            return STRING_SERIALIZER.deserialize(json).map(MessageIdDto::new);
        }

        @Override
        public String getName() {
            return "MessageIdDtoSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class DateSerializer
    implements Serializer<ZonedDateTime> {
        @Override
        public JsonNode serialize(ZonedDateTime object) {
            String serialized = object.format(DateTimeFormatter.ISO_DATE_TIME);
            return TextNode.valueOf((String)serialized);
        }

        @Override
        public Optional<ZonedDateTime> deserialize(JsonNode json) {
            if (json instanceof TextNode) {
                String serialized = json.asText();
                return Optional.of(ZonedDateTime.parse(serialized, DateTimeFormatter.ISO_DATE_TIME));
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "DateSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class DoubleSerializer
    implements Serializer<Double> {
        @Override
        public JsonNode serialize(Double object) {
            return DoubleNode.valueOf((double)object);
        }

        @Override
        public Optional<Double> deserialize(JsonNode json) {
            if (json instanceof DoubleNode || json instanceof FloatNode) {
                return Optional.of(json.asDouble());
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "DoubleSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class FloatSerializer
    implements Serializer<Float> {
        @Override
        public JsonNode serialize(Float object) {
            return FloatNode.valueOf((float)object.floatValue());
        }

        @Override
        public Optional<Float> deserialize(JsonNode json) {
            if (json instanceof FloatNode) {
                return Optional.of(Float.valueOf(json.floatValue()));
            }
            if (json instanceof DoubleNode) {
                return Optional.of(Float.valueOf(json.floatValue()));
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "FloatSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class LongSerializer
    implements Serializer<Long> {
        @Override
        public JsonNode serialize(Long object) {
            return LongNode.valueOf((long)object);
        }

        @Override
        public Optional<Long> deserialize(JsonNode json) {
            if (json instanceof LongNode) {
                return Optional.of(json.asLong());
            }
            if (json instanceof IntNode) {
                return Optional.of(Long.valueOf(json.asInt()));
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "LongSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class IntSerializer
    implements Serializer<Integer> {
        @Override
        public JsonNode serialize(Integer object) {
            return IntNode.valueOf((int)object);
        }

        @Override
        public Optional<Integer> deserialize(JsonNode json) {
            if (json instanceof IntNode) {
                return Optional.of(json.asInt());
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "IntSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class StringSerializer
    implements Serializer<String> {
        @Override
        public JsonNode serialize(String object) {
            return TextNode.valueOf((String)object);
        }

        @Override
        public Optional<String> deserialize(JsonNode json) {
            if (json instanceof TextNode) {
                return Optional.of(json.asText());
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "StringSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class BooleanSerializer
    implements Serializer<Boolean> {
        @Override
        public JsonNode serialize(Boolean object) {
            return BooleanNode.valueOf((boolean)object);
        }

        @Override
        public Optional<Boolean> deserialize(JsonNode json) {
            if (json instanceof BooleanNode) {
                return Optional.of(json.asBoolean());
            }
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "BooleanSerializer";
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass();
        }
    }

    public static class Registry {
        private static ImmutableMap<String, Serializer<?>> serializers = (ImmutableMap)Stream.of(BOOLEAN_SERIALIZER, STRING_SERIALIZER, INT_SERIALIZER, LONG_SERIALIZER, FLOAT_SERIALIZER, DOUBLE_SERIALIZER, DATE_SERIALIZER, MESSAGE_ID_DTO_SERIALIZER, new ArbitrarySerializableSerializer(), URL_SERIALIZER, new CollectionSerializer(), new MapSerializer(), new FSTSerializer(), new OptionalSerializer()).collect(ImmutableMap.toImmutableMap(Serializer::getName, Function.identity()));

        static Optional<Serializer<?>> find(String name) {
            return Optional.ofNullable((Serializer)serializers.get((Object)name));
        }
    }
}

