/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.james.core.MailAddress;

public class PerRecipientHeaders
implements Serializable {
    private Multimap<MailAddress, Header> headersByRecipient = ArrayListMultimap.create();

    public Multimap<MailAddress, Header> getHeadersByRecipient() {
        return ArrayListMultimap.create(this.headersByRecipient);
    }

    public Collection<MailAddress> getRecipientsWithSpecificHeaders() {
        return this.headersByRecipient.keySet();
    }

    public Collection<Header> getHeadersForRecipient(MailAddress recipient) {
        return this.headersByRecipient.get((Object)recipient);
    }

    public Collection<String> getHeaderNamesForRecipient(MailAddress recipient) {
        return (Collection)this.headersByRecipient.get((Object)recipient).stream().map(Header::getName).collect(Guavate.toImmutableSet());
    }

    public PerRecipientHeaders addHeaderForRecipient(Header header, MailAddress recipient) {
        this.headersByRecipient.put((Object)recipient, (Object)header);
        return this;
    }

    public PerRecipientHeaders addHeaderForRecipient(Header.Builder header, MailAddress recipient) {
        this.headersByRecipient.put((Object)recipient, (Object)header.build());
        return this;
    }

    public void addAll(PerRecipientHeaders other) {
        this.headersByRecipient.putAll(other.headersByRecipient);
    }

    public final boolean equals(Object o) {
        if (o instanceof PerRecipientHeaders) {
            PerRecipientHeaders that = (PerRecipientHeaders)o;
            return Objects.equal(this.headersByRecipient, that.headersByRecipient);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.headersByRecipient});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("headersByRecipient", this.headersByRecipient).toString();
    }

    public static class Header
    implements Serializable {
        public static final String SEPARATOR = ": ";
        private final String name;
        private final String value;

        public static Builder builder() {
            return new Builder();
        }

        public static Header fromString(String value) {
            Preconditions.checkArgument((boolean)value.contains(SEPARATOR), (Object)"Header is string form needs to contain ': ' separator");
            List parts = Splitter.on((String)SEPARATOR).splitToList((CharSequence)value);
            return new Header((String)parts.get(0), Joiner.on((String)SEPARATOR).join((Iterable)parts.stream().skip(1L).collect(Guavate.toImmutableList())));
        }

        @VisibleForTesting
        Header(String name, String value) {
            Preconditions.checkArgument((!name.contains(":") ? 1 : 0) != 0, (Object)"Header name should not contain separator");
            Preconditions.checkArgument((!name.contains("\n") ? 1 : 0) != 0, (Object)"Header name should not contain line break");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String asString() {
            return this.name + SEPARATOR + this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Header) {
                Header that = (Header)o;
                return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.value, (Object)that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.value});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
        }

        public static class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Header build() {
                Preconditions.checkNotNull((Object)this.name);
                Preconditions.checkNotNull((Object)this.value);
                return new Header(this.name, this.value);
            }
        }
    }
}

