/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import uk.nominet.dnsjnio.Connection;
import uk.nominet.dnsjnio.ConnectionListener;
import uk.nominet.dnsjnio.DnsController;

public class TCPConnection
extends Connection {
    boolean packetInProgress = false;

    public TCPConnection(ConnectionListener connectionListener) {
        super(connectionListener);
    }

    public TCPConnection(ConnectionListener connectionListener, int n) {
        super(connectionListener, n);
    }

    protected boolean close() {
        SocketChannel socketChannel;
        boolean bl = false;
        if (this.getState() != 0 && this.sk != null && (socketChannel = (SocketChannel)this.sk.channel()) != null && socketChannel.isOpen()) {
            bl = true;
            if (this.getState() == 2) {
                this.sk.interestOps(0);
                this.setState(3);
                Socket socket = socketChannel.socket();
                try {
                    socket.shutdownOutput();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.closeComplete();
        }
        return bl;
    }

    protected void connect() {
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.socket().bind(this.localAddress);
            this.sk = socketChannel.register(DnsController.getSelector(), 0);
            socketChannel.connect(this.remoteAddress);
            this.attach(this.sk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close();
        }
    }

    public void doConnect() {
        SocketChannel socketChannel = (SocketChannel)this.sk.channel();
        try {
            socketChannel.finishConnect();
            this.sk.interestOps(4);
            this.setState(2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.closeComplete();
        }
    }

    public void doRead() {
        int n;
        SocketChannel socketChannel = (SocketChannel)this.sk.channel();
        this.readFromChannel(socketChannel);
        while (this.recvCount > 2 && this.recvBytes != null && this.recvCount >= (n = ((this.recvBytes[0] & 0xFF) << 8) + (this.recvBytes[1] & 0xFF)) + 2) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.recvBytes, 2, byArray, 0, n);
            this.sendToUser(byArray);
            this.clearRecvBytes(n + 2);
        }
    }

    protected void write(ByteBuffer byteBuffer) {
        SocketChannel socketChannel = (SocketChannel)this.sk.channel();
        if (socketChannel.isOpen()) {
            if (byteBuffer.hasRemaining()) {
                try {
                    socketChannel.write(byteBuffer);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.closeComplete();
                }
            }
            this.commonEndWrite(byteBuffer);
        }
    }

    protected byte[] decorateData(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        byArray2[0] = (byte)(byArray.length >>> 8);
        byArray2[1] = (byte)(byArray.length & 0xFF);
        return byArray2;
    }

    protected void closeChannel() throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.sk.channel();
        if (socketChannel != null && socketChannel.isOpen()) {
            socketChannel.close();
        }
    }

    public void attach(SelectionKey selectionKey) {
        this.sk = selectionKey;
        selectionKey.attach(this);
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        if (socketChannel.isConnected()) {
            selectionKey.interestOps(5);
            this.setState(2);
        } else if (socketChannel.isConnectionPending()) {
            selectionKey.interestOps(8);
            this.setState(1);
        }
    }
}

