/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverListener;
import uk.nominet.dnsjnio.AbstractTransaction;
import uk.nominet.dnsjnio.Connection;
import uk.nominet.dnsjnio.NonblockingResolver;
import uk.nominet.dnsjnio.QueryData;
import uk.nominet.dnsjnio.ResponseQueue;
import uk.nominet.dnsjnio.SinglePortUDPConnection;
import uk.nominet.dnsjnio.TCPConnection;
import uk.nominet.dnsjnio.Timer;
import uk.nominet.dnsjnio.UDPConnection;

public class SinglePortTransactionController
extends AbstractTransaction {
    private Map tcpQueryDataMap = new HashMap();
    private Map udpQueryDataMap = new HashMap();
    private TCPConnection tcpConnection;
    private UDPConnection udpConnection;
    protected InetSocketAddress remoteAddress;
    protected InetSocketAddress localAddress;
    static int udpOpenedCount = 0;
    static int udpOpeningCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean headerIdNotInUse(int n) {
        Map map = this.tcpQueryDataMap;
        synchronized (map) {
            if (this.tcpQueryDataMap.keySet().contains(new Integer(n))) {
                return false;
            }
        }
        map = this.udpQueryDataMap;
        synchronized (map) {
            if (this.udpQueryDataMap.keySet().contains(new Integer(n))) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startConnect(QueryData queryData) {
        this.startTimer(queryData);
        if (queryData.isTcp()) {
            Map map = this.tcpQueryDataMap;
            synchronized (map) {
                this.tcpQueryDataMap.put(new Integer(queryData.getQuery().getHeader().getID()), queryData);
            }
            if (this.tcpConnection != null) {
                queryData.setConnection(this.tcpConnection);
                if (this.tcpConnection.getState() == 1) {
                    return;
                }
                if (this.tcpConnection.getState() == 2) {
                    this.readyToSend(this.tcpConnection);
                    return;
                }
                if (this.tcpConnection.getState() == 3) {
                    return;
                }
                if (this.tcpConnection.getState() == 0) {
                    this.getNewTcpConnection(queryData);
                }
            } else {
                this.getNewTcpConnection(queryData);
            }
        } else {
            Map map = this.udpQueryDataMap;
            synchronized (map) {
                this.udpQueryDataMap.put(new Integer(queryData.getQuery().getHeader().getID()), queryData);
            }
            if (this.udpConnection != null && this.udpConnection.getState() != 0) {
                queryData.setConnection(this.udpConnection);
                if (this.udpConnection.getState() == 1) {
                    return;
                }
                if (this.udpConnection.getState() == 2) {
                    this.readyToSend(this.udpConnection);
                    return;
                }
                if (this.udpConnection.getState() == 3) {
                    return;
                }
            } else {
                this.getNewUdpConnection(queryData);
            }
        }
        queryData.getConnection().connect(this.remoteAddress, this.localAddress);
    }

    private void getNewTcpConnection(QueryData queryData) {
        this.tcpConnection = new TCPConnection(this, 65536);
        queryData.setConnection(this.tcpConnection);
    }

    private void getNewUdpConnection(QueryData queryData) {
        this.udpConnection = new SinglePortUDPConnection(this, this.localAddress.getPort());
        queryData.setConnection(this.udpConnection);
    }

    public void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.remoteAddress = inetSocketAddress;
    }

    public void setLocalAddress(InetSocketAddress inetSocketAddress) {
        this.localAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SinglePortTransactionController(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        this.remoteAddress = inetSocketAddress;
        this.localAddress = inetSocketAddress2;
        Map map = this.tcpQueryDataMap;
        synchronized (map) {
            this.tcpQueryDataMap = new HashMap();
        }
        map = this.udpQueryDataMap;
        synchronized (map) {
            this.udpQueryDataMap = new HashMap();
        }
    }

    public void sendQuery(QueryData queryData, Object object, ResponseQueue responseQueue, long l) {
        queryData.setResponseQueue(responseQueue);
        queryData.setId(object);
        queryData.setEndTime(l);
        this.startConnect(queryData);
    }

    public void sendQuery(QueryData queryData, Object object, ResolverListener resolverListener, long l) {
        queryData.setListener(resolverListener);
        queryData.setId(object);
        queryData.setEndTime(l);
        this.startConnect(queryData);
    }

    private void startTimer(QueryData queryData) {
        Timer.addTimeout(queryData.getEndTime(), this, queryData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean disconnect(QueryData queryData) {
        Map map = this.getQueryDataMap(queryData.getConnection());
        boolean bl = false;
        Map map2 = map;
        synchronized (map2) {
            map.remove(new Integer(queryData.getQuery().getHeader().getID()));
            if (map.size() == 0) {
                bl = true;
            }
        }
        if (bl) {
            this.disconnect(queryData.getConnection());
        }
        return true;
    }

    public void readyToSend(Connection connection) {
        QueryData queryData = null;
        do {
            if ((queryData = this.getNextQueryData(connection)) == null) continue;
            queryData.setSent(true);
            SinglePortTransactionController.sendQuery(connection, queryData.getQuery());
        } while (queryData != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryData getNextQueryData(Connection connection) {
        Map map;
        Map map2 = map = this.getQueryDataMap(connection);
        synchronized (map2) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                QueryData queryData = (QueryData)iterator.next();
                if (queryData.isSent() || queryData.getConnection() != connection) continue;
                return queryData;
            }
        }
        return null;
    }

    private Map getQueryDataMap(Connection connection) {
        Map map = this.udpQueryDataMap;
        if (this.tcpConnection != null && connection.equals(this.tcpConnection)) {
            map = this.tcpQueryDataMap;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(Connection connection) {
        Map map = this.getQueryDataMap(connection);
        boolean bl = false;
        Map map2 = map;
        synchronized (map2) {
            if (map.size() != 0) {
                bl = true;
            }
        }
        if (bl) {
            connection.connect(this.remoteAddress, this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataAvailable(byte[] byArray, Connection connection) {
        try {
            Map map;
            Message message = NonblockingResolver.parseMessage(byArray);
            QueryData queryData = null;
            Map map2 = map = this.getQueryDataMap(connection);
            synchronized (map2) {
                queryData = (QueryData)map.get(new Integer(message.getHeader().getID()));
            }
            if (queryData == null) {
                return;
            }
            this.disconnect(queryData);
            NonblockingResolver.verifyTSIG(queryData.getQuery(), message, byArray, queryData.getTsig());
            if (!queryData.isTcp() && !queryData.isIgnoreTruncation() && message.getHeader().getFlag(6)) {
                this.cancelTimer(queryData);
                queryData.setTcp(true);
                this.startConnect(queryData);
                return;
            }
            this.returnResponse(message, queryData);
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void returnResponse(Message message, QueryData queryData) {
        if (!queryData.isAnswered()) {
            queryData.setAnswered(true);
            this.cancelTimer(queryData);
            SinglePortTransactionController.returnResponse(queryData.getListener(), queryData.getResponseQueue(), message, queryData.getId());
        }
    }

    protected void returnException(Exception exception, QueryData queryData) {
        if (!queryData.isAnswered()) {
            queryData.setAnswered(true);
            this.cancelTimer(queryData);
            this.returnException(queryData.getListener(), queryData.getResponseQueue(), exception, queryData.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimer(QueryData queryData) {
        Map map;
        Timer.cancelTimeout(this, queryData);
        queryData.setResponded(true);
        Map map2 = map = this.getQueryDataMap(queryData.getConnection());
        synchronized (map2) {
            map.remove(new Integer(queryData.getQuery().getHeader().getID()));
        }
    }
}

