/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.WireParseException;
import uk.nominet.dnsjnio.INonblockingResolver;
import uk.nominet.dnsjnio.QueryData;
import uk.nominet.dnsjnio.Response;
import uk.nominet.dnsjnio.ResponseQueue;
import uk.nominet.dnsjnio.SinglePortTransactionController;
import uk.nominet.dnsjnio.Transaction;

public class NonblockingResolver
implements INonblockingResolver {
    public static final int DEFAULT_PORT = 53;
    private InetSocketAddress remoteAddress = new InetSocketAddress(53);
    private boolean useTCP = false;
    private boolean ignoreTruncation;
    private TSIG tsig;
    private int timeoutValue = 10000;
    public static final int DEFAULT_EDNS_PAYLOADSIZE = 1280;
    private static final short DEFAULT_UDPSIZE = 512;
    private OPTRecord queryOPT;
    private static String defaultResolver = "localhost";
    private static short uniqueID = 0;
    private static Random random = new Random();
    private SinglePortTransactionController transactionController;
    private boolean useSinglePort = false;
    private InetSocketAddress localAddress = new InetSocketAddress(0);

    public NonblockingResolver(String string) throws UnknownHostException {
        if (string == null && (string = ResolverConfig.getCurrentConfig().server()) == null) {
            string = defaultResolver;
        }
        InetAddress inetAddress = string.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        this.remoteAddress = new InetSocketAddress(inetAddress, 53);
        this.transactionController = new SinglePortTransactionController(this.remoteAddress, this.localAddress);
    }

    public NonblockingResolver() throws UnknownHostException {
        this(null);
    }

    InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public static void setDefaultResolver(String string) {
        defaultResolver = string;
    }

    public void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.remoteAddress = inetSocketAddress;
        this.transactionController.setRemoteAddress(this.remoteAddress);
    }

    public void setRemoteAddress(InetAddress inetAddress) {
        this.remoteAddress = new InetSocketAddress(inetAddress, this.remoteAddress.getPort());
        this.transactionController.setRemoteAddress(this.remoteAddress);
    }

    public void setRemotePort(int n) {
        this.remoteAddress = new InetSocketAddress(this.remoteAddress.getAddress(), n);
        this.transactionController.setRemoteAddress(this.remoteAddress);
    }

    public void setLocalAddress(InetSocketAddress inetSocketAddress) {
        this.localAddress = inetSocketAddress;
        this.transactionController.setLocalAddress(this.localAddress);
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = new InetSocketAddress(inetAddress, 0);
        this.transactionController.setLocalAddress(this.localAddress);
    }

    public void setPort(int n) {
        this.setRemotePort(n);
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setTCP(boolean bl) {
        this.useTCP = bl;
    }

    public boolean isTCP() {
        return this.useTCP;
    }

    public void setIgnoreTruncation(boolean bl) {
        this.ignoreTruncation = bl;
    }

    public void setSingleTcpPort(boolean bl) {
        this.useSinglePort = bl;
    }

    public boolean isSingleTcpPort() {
        return this.useSinglePort;
    }

    public void setLocalTcpPort(int n) {
        this.localAddress = new InetSocketAddress(this.localAddress.getHostName(), n);
        this.transactionController.setLocalAddress(this.localAddress);
    }

    public void setEDNS(int n, int n2, int n3, List list) {
        if (n != 0 && n != -1) {
            throw new IllegalArgumentException("invalid EDNS level - must be 0 or -1");
        }
        if (n2 == 0) {
            n2 = 1280;
        }
        this.queryOPT = new OPTRecord(n2, 0, n, n3, list);
    }

    public void setEDNS(int n) {
        this.setEDNS(n, 0, 0, null);
    }

    private void applyEDNS(Message message) {
        if (this.queryOPT == null || message.getOPT() != null) {
            return;
        }
        message.addRecord((Record)this.queryOPT, 3);
    }

    public void setTSIGKey(TSIG tSIG) {
        this.tsig = tSIG;
    }

    public void setTSIGKey(Name name, byte[] byArray) {
        this.tsig = new TSIG(name, byArray);
    }

    public void setTSIGKey(String string, String string2) {
        this.tsig = new TSIG(string, string2);
    }

    protected TSIG getTSIGKey() {
        return this.tsig;
    }

    public void setTimeout(int n) {
        this.setTimeout(n, 0);
    }

    public void setTimeout(int n, int n2) {
        this.timeoutValue = n * 1000 + n2;
    }

    int getTimeout() {
        return this.timeoutValue / 1000;
    }

    public int getTimeoutMillis() {
        return this.timeoutValue;
    }

    private int maxUDPSize(Message message) {
        OPTRecord oPTRecord = message.getOPT();
        if (oPTRecord == null) {
            return 512;
        }
        return oPTRecord.getPayloadSize();
    }

    public Message send(Message message) throws IOException {
        ResponseQueue responseQueue = new ResponseQueue();
        Object object = this.sendAsync(message, responseQueue);
        Response response = responseQueue.getItem();
        if (response.getId() != object) {
            throw new IllegalStateException("Wrong id (" + response.getId() + ", should be " + object + ") returned from sendAsync()!");
        }
        if (response.isException()) {
            if (response.getException() instanceof SocketTimeoutException) {
                throw new SocketTimeoutException();
            }
            if (response.getException() instanceof IOException) {
                throw (IOException)response.getException();
            }
            throw new IllegalStateException("Unexpected exception!\r\n" + response.getException().toString());
        }
        return response.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Integer n;
        NonblockingResolver nonblockingResolver = this;
        synchronized (nonblockingResolver) {
            short s = uniqueID;
            uniqueID = (short)(s + 1);
            n = new Integer(s);
        }
        this.sendAsync(message, (Object)n, resolverListener);
        return n;
    }

    public void sendAsync(Message message, Object object, ResolverListener resolverListener) {
        this.sendAsync(message, object, this.timeoutValue, this.useTCP, null, false, resolverListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendAsync(Message message, ResponseQueue responseQueue) {
        Integer n;
        NonblockingResolver nonblockingResolver = this;
        synchronized (nonblockingResolver) {
            short s = uniqueID;
            uniqueID = (short)(s + 1);
            n = new Integer(s);
        }
        this.sendAsync(message, (Object)n, responseQueue);
        return n;
    }

    public void sendAsync(Message message, Object object, ResponseQueue responseQueue) {
        this.sendAsync(message, object, this.timeoutValue, this.useTCP, responseQueue);
    }

    public void sendAsync(Message message, Object object, int n, boolean bl, ResponseQueue responseQueue) {
        this.sendAsync(message, object, n, bl, responseQueue, true, null);
    }

    private void sendAsync(Message message, Object object, int n, boolean bl, ResponseQueue responseQueue, boolean bl2, ResolverListener resolverListener) {
        Record record;
        if (!bl2 && resolverListener == null) {
            throw new IllegalArgumentException("No ResolverListener supplied for callback when useResponsequeue = true!");
        }
        if (Options.check((String)"verbose")) {
            System.err.println("Sending to " + this.remoteAddress.getAddress() + ", from " + this.remoteAddress.getAddress());
        }
        if (message.getHeader().getOpcode() == 0 && (record = message.getQuestion()) != null && record.getType() == 252) {
            throw new UnsupportedOperationException("AXFR not implemented in NonblockingResolver");
        }
        int n2 = n;
        Message message2 = (Message)message.clone();
        this.applyEDNS(message2);
        if (this.tsig != null) {
            this.tsig.apply(message2, null);
        }
        byte[] byArray = message2.toWire(65535);
        int n3 = this.maxUDPSize(message2);
        boolean bl3 = false;
        long l = System.currentTimeMillis() + (long)n2;
        if (bl || byArray.length > n3) {
            bl3 = true;
        }
        if (this.useSinglePort && bl3 && this.transactionController.headerIdNotInUse(message2.getHeader().getID())) {
            QueryData queryData = new QueryData();
            queryData.setTcp(bl3);
            queryData.setIgnoreTruncation(this.ignoreTruncation);
            queryData.setTsig(this.tsig);
            queryData.setQuery(message2);
            if (!bl3) {
                queryData.setUdpSize(n3);
            }
            if (bl2) {
                this.transactionController.sendQuery(queryData, object, responseQueue, l);
            } else {
                this.transactionController.sendQuery(queryData, object, resolverListener, l);
            }
        } else {
            InetSocketAddress inetSocketAddress = NonblockingResolver.getNewInetSocketAddressWithRandomPort(this.localAddress.getAddress());
            Transaction transaction = new Transaction(this.remoteAddress, inetSocketAddress, this.tsig, bl3, this.ignoreTruncation);
            if (!bl3) {
                transaction.setUdpSize(n3);
            }
            if (bl2) {
                transaction.sendQuery(message2, object, responseQueue, l);
            } else {
                transaction.sendQuery(message2, object, resolverListener, l);
            }
        }
    }

    public static InetSocketAddress getNewInetSocketAddressWithRandomPort(InetAddress inetAddress) {
        int n = 1024 + random.nextInt(64511);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        return inetSocketAddress;
    }

    public static Message parseMessage(byte[] byArray) throws WireParseException {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            WireParseException wireParseException;
            if (Options.check((String)"verbose")) {
                iOException.printStackTrace();
            }
            if (!(iOException instanceof WireParseException)) {
                wireParseException = new WireParseException("Error parsing message");
            }
            throw (WireParseException)wireParseException;
        }
    }

    public static void verifyTSIG(Message message, Message message2, byte[] byArray, TSIG tSIG) {
        if (tSIG == null) {
            return;
        }
        int n = tSIG.verify(message2, byArray, message.getTSIG());
        if (Options.check((String)"verbose")) {
            System.err.println("TSIG verify: " + Rcode.string((int)n));
        }
    }

    public static boolean isDataComplete(byte[] byArray) {
        try {
            if (byArray.length < 12) {
                return false;
            }
            Message message = NonblockingResolver.parseMessage(byArray);
            int n = message.numBytes();
            boolean bl = n == byArray.length;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

