/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import uk.nominet.dnsjnio.ExtendedNonblockingResolver;
import uk.nominet.dnsjnio.Response;
import uk.nominet.dnsjnio.ResponseQueue;

public final class LookupAsynch {
    private static ExtendedNonblockingResolver defaultResolver;
    private static Name[] defaultSearchPath;
    private static Map defaultCaches;
    private static Random random;
    private ExtendedNonblockingResolver resolver;
    private Name[] searchPath;
    private Cache cache;
    private boolean temporary_cache;
    private int credibility;
    private Name name;
    private int type;
    private int dclass;
    private boolean verbose;
    private int iterations;
    private boolean foundAlias;
    private boolean done;
    private boolean doneCurrent;
    private List aliases;
    private Record[] answers;
    private int result;
    private String error;
    private boolean nxdomain;
    private boolean badresponse;
    private String badresponse_error;
    private boolean networkerror;
    private boolean timedout;
    private boolean nametoolong;
    private boolean referral;
    private LookupContinuation currentLookupContinuation;
    private static final Name[] noAliases;
    public static final int SUCCESSFUL = 0;
    public static final int UNRECOVERABLE = 1;
    public static final int TRY_AGAIN = 2;
    public static final int HOST_NOT_FOUND = 3;
    public static final int TYPE_NOT_FOUND = 4;
    private List searchNames;
    private Runnable completionTask;
    private static int id;
    private static Thread workerThread;
    private static ResponseQueue responseQueue;
    private static Map pendingLookups;

    public static synchronized void refreshDefault() {
        try {
            defaultResolver = ExtendedNonblockingResolver.newInstance();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Failed to initialize resolver");
        }
        defaultSearchPath = ResolverConfig.getCurrentConfig().searchPath();
        defaultCaches = new HashMap();
    }

    public static synchronized ExtendedNonblockingResolver getDefaultResolver() {
        return defaultResolver;
    }

    public static synchronized void setDefaultResolver(ExtendedNonblockingResolver extendedNonblockingResolver) {
        defaultResolver = extendedNonblockingResolver;
    }

    public static synchronized Cache getDefaultCache(int n) {
        DClass.check((int)n);
        Cache cache = (Cache)defaultCaches.get(new Integer(n));
        if (cache == null) {
            cache = new Cache(n);
            defaultCaches.put(new Integer(n), cache);
        }
        return cache;
    }

    public static synchronized void setDefaultCache(Cache cache, int n) {
        DClass.check((int)n);
        defaultCaches.put(new Integer(n), cache);
    }

    public static synchronized Name[] getDefaultSearchPath() {
        return defaultSearchPath;
    }

    public static synchronized void setDefaultSearchPath(Name[] nameArray) {
        defaultSearchPath = nameArray;
    }

    public static synchronized void setDefaultSearchPath(String[] stringArray) throws TextParseException {
        if (stringArray == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nameArray[i] = Name.fromString((String)stringArray[i], (Name)Name.root);
        }
        defaultSearchPath = nameArray;
    }

    private final void reset() {
        this.iterations = 0;
        this.foundAlias = false;
        this.done = false;
        this.doneCurrent = false;
        this.aliases = null;
        this.answers = null;
        this.result = -1;
        this.error = null;
        this.nxdomain = false;
        this.badresponse = false;
        this.badresponse_error = null;
        this.networkerror = false;
        this.timedout = false;
        this.nametoolong = false;
        this.referral = false;
        this.searchNames = null;
        if (this.temporary_cache) {
            this.cache.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupAsynch(Name name, int n, int n2) {
        Type.check((int)n);
        DClass.check((int)n2);
        if (!Type.isRR((int)n) && n != 255) {
            throw new IllegalArgumentException("Cannot query for meta-types other than ANY");
        }
        this.name = name;
        this.type = n;
        this.dclass = n2;
        Class clazz = LookupAsynch.class;
        synchronized (clazz) {
            this.resolver = LookupAsynch.getDefaultResolver();
            this.searchPath = LookupAsynch.getDefaultSearchPath();
            this.cache = LookupAsynch.getDefaultCache(n2);
            if (responseQueue == null) {
                responseQueue = new ResponseQueue();
            }
            if (pendingLookups == null) {
                pendingLookups = new HashMap();
            }
            if (workerThread == null) {
                workerThread = new Thread((Runnable)new ProcessingTask(), "LookupAsynchResolver");
                workerThread.start();
            }
        }
        this.credibility = 3;
        this.verbose = Options.check((String)"verbose");
        this.result = -1;
    }

    public LookupAsynch(Name name, int n) {
        this(name, n, 1);
    }

    public LookupAsynch(Name name) {
        this(name, 1, 1);
    }

    public LookupAsynch(String string, int n, int n2) throws TextParseException {
        this(Name.fromString((String)string), n, n2);
    }

    public LookupAsynch(String string, int n) throws TextParseException {
        this(Name.fromString((String)string), n, 1);
    }

    public LookupAsynch(String string) throws TextParseException {
        this(Name.fromString((String)string), 1, 1);
    }

    public void setResolver(ExtendedNonblockingResolver extendedNonblockingResolver) {
        this.resolver = extendedNonblockingResolver;
    }

    public void setSearchPath(Name[] nameArray) {
        this.searchPath = nameArray;
    }

    public void setSearchPath(String[] stringArray) throws TextParseException {
        if (stringArray == null) {
            this.searchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nameArray[i] = Name.fromString((String)stringArray[i], (Name)Name.root);
        }
        this.searchPath = nameArray;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            this.cache = new Cache(this.dclass);
            this.temporary_cache = true;
        } else {
            this.cache = cache;
            this.temporary_cache = false;
        }
    }

    public void setCredibility(int n) {
        this.credibility = n;
    }

    private LookupContinuation follow(Name name, Name name2) {
        this.foundAlias = true;
        this.badresponse = false;
        this.networkerror = false;
        this.timedout = false;
        this.nxdomain = false;
        this.referral = false;
        ++this.iterations;
        if (this.iterations >= 6 || name.equals((Object)name2)) {
            this.result = 1;
            this.error = "CNAME loop";
            this.done = true;
            return null;
        }
        if (this.aliases == null) {
            this.aliases = new ArrayList();
        }
        this.aliases.add(name2);
        return this.lookup(name);
    }

    private LookupContinuation processResponse(Name name, SetResponse setResponse) {
        if (setResponse.isSuccessful()) {
            RRset[] rRsetArray = setResponse.answers();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < rRsetArray.length; ++i) {
                Iterator iterator = rRsetArray[i].rrs();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            this.result = 0;
            this.answers = arrayList.toArray(new Record[arrayList.size()]);
            this.done = true;
        } else if (setResponse.isNXDOMAIN()) {
            this.nxdomain = true;
            this.doneCurrent = true;
            if (this.iterations > 0) {
                this.result = 3;
                this.done = true;
            }
        } else if (setResponse.isNXRRSET()) {
            this.result = 4;
            this.answers = null;
            this.done = true;
        } else {
            if (setResponse.isCNAME()) {
                CNAMERecord cNAMERecord = setResponse.getCNAME();
                return this.follow(cNAMERecord.getTarget(), name);
            }
            if (setResponse.isDNAME()) {
                DNAMERecord dNAMERecord = setResponse.getDNAME();
                Name name2 = null;
                try {
                    name2 = name.fromDNAME(dNAMERecord);
                }
                catch (NameTooLongException nameTooLongException) {
                    this.result = 1;
                    this.error = "Invalid DNAME target";
                    this.done = true;
                }
                if (name2 != null) {
                    return this.follow(name2, name);
                }
            } else if (setResponse.isDelegation()) {
                this.referral = true;
            }
        }
        return null;
    }

    private LookupContinuation lookup(Name name) {
        LookupContinuation lookupContinuation;
        SetResponse setResponse = this.cache.lookupRecords(name, this.type, this.credibility);
        if (this.verbose) {
            System.err.println("lookup " + name + " " + Type.string((int)this.type));
            System.err.println(setResponse);
        }
        if ((lookupContinuation = this.processResponse(name, setResponse)) != null) {
            ResponseProcessor responseProcessor = lookupContinuation.getResponseProcessor();
            CompositeResponseProcessor compositeResponseProcessor = new CompositeResponseProcessor(responseProcessor, name);
            return new LookupContinuation(compositeResponseProcessor, lookupContinuation.getQuery());
        }
        return this.lookupContinue(name);
    }

    private LookupContinuation lookupContinue(Name name) {
        if (this.done || this.doneCurrent) {
            return null;
        }
        Record record = Record.newRecord((Name)name, (int)this.type, (int)this.dclass);
        Message message = Message.newQuery((Record)record);
        return new LookupContinuation(new ResponseProcessor(){

            public LookupContinuation processResponse(Message message, Response response) {
                return LookupAsynch.this.processLookupResponse(message, response);
            }
        }, message);
    }

    private Response processQuery(Message message) {
        Response response = new Response();
        try {
            Message message2 = (Message)message.clone();
            int n = random.nextInt(65535);
            message2.getHeader().setID(n);
            response.setMessage(this.resolver.send(message2));
        }
        catch (IOException iOException) {
            response.setException(true);
            response.setException(iOException);
        }
        return response;
    }

    private LookupContinuation processLookupResponse(Message message, Response response) {
        Message message2 = null;
        if (response.isException()) {
            if (response.getException() instanceof InterruptedIOException) {
                this.timedout = true;
            } else {
                this.networkerror = true;
            }
            return null;
        }
        message2 = response.getMessage();
        int n = message2.getHeader().getRcode();
        if (n != 0 && n != 3) {
            this.badresponse = true;
            this.badresponse_error = Rcode.string((int)n);
            return null;
        }
        if (!message.getQuestion().equals((Object)message2.getQuestion())) {
            this.badresponse = true;
            this.badresponse_error = "response does not match query";
            return null;
        }
        SetResponse setResponse = this.cache.addMessage(message2);
        if (setResponse == null) {
            setResponse = this.cache.lookupRecords(message.getQuestion().getName(), this.type, this.credibility);
        }
        if (this.verbose) {
            System.err.println("queried " + message.getQuestion().getName() + " " + Type.string((int)this.type));
            System.err.println(setResponse);
        }
        return this.processResponse(message.getQuestion().getName(), setResponse);
    }

    private LookupContinuation resolve(Name name, Name name2) {
        this.doneCurrent = false;
        Name name3 = null;
        if (name2 == null) {
            name3 = name;
        } else {
            try {
                name3 = Name.concatenate((Name)name, (Name)name2);
            }
            catch (NameTooLongException nameTooLongException) {
                this.nametoolong = true;
                return null;
            }
        }
        return this.lookup(name3);
    }

    public Record[] run() {
        this.initLookup();
        Name name = (Name)this.searchNames.remove(0);
        this.currentLookupContinuation = this.resolve(this.name, name);
        while (this.currentLookupContinuation != null) {
            Response response = this.processQuery(this.currentLookupContinuation.getQuery());
            this.currentLookupContinuation = this.processResponse(response);
        }
        return this.answers;
    }

    public boolean runAsynch(Runnable runnable) {
        this.completionTask = runnable;
        this.initLookup();
        Name name = (Name)this.searchNames.remove(0);
        LookupContinuation lookupContinuation = this.resolve(this.name, name);
        if (lookupContinuation == null) {
            this.completeLookup();
            return true;
        }
        this.submitQuery(lookupContinuation);
        return false;
    }

    private void submitQuery(LookupContinuation lookupContinuation) {
        this.currentLookupContinuation = lookupContinuation;
        Integer n = new Integer(this.nextId());
        pendingLookups.put(n, this);
        Message message = (Message)lookupContinuation.getQuery().clone();
        int n2 = random.nextInt(65535);
        message.getHeader().setID(n2);
        this.resolver.sendAsync(message, n, responseQueue);
    }

    private synchronized int nextId() {
        return id++;
    }

    private void initLookup() {
        if (this.done) {
            this.reset();
        }
        this.searchNames = new LinkedList();
        if (this.name.isAbsolute()) {
            this.searchNames.add(null);
        } else if (this.searchPath == null) {
            this.searchNames.add(Name.root);
        } else {
            if (this.name.labels() > 1) {
                this.searchNames.add(Name.root);
            }
            for (int i = 0; i < this.searchPath.length; ++i) {
                this.searchNames.add(this.searchPath[i]);
            }
        }
    }

    private LookupContinuation processResponse(Response response) {
        LookupContinuation lookupContinuation = this.currentLookupContinuation;
        LookupContinuation lookupContinuation2 = lookupContinuation.getResponseProcessor().processResponse(lookupContinuation.getQuery(), response);
        if (lookupContinuation2 == null && !this.done && !this.foundAlias && this.searchNames.size() > 0) {
            Name name = (Name)this.searchNames.remove(0);
            lookupContinuation2 = this.resolve(this.name, name);
        }
        return lookupContinuation2;
    }

    private void completeLookup() {
        if (!this.done) {
            if (this.badresponse) {
                this.result = 2;
                this.error = this.badresponse_error;
                this.done = true;
            } else if (this.timedout) {
                this.result = 2;
                this.error = "timed out";
                this.done = true;
            } else if (this.networkerror) {
                this.result = 2;
                this.error = "network error";
                this.done = true;
            } else if (this.nxdomain) {
                this.result = 3;
                this.done = true;
            } else if (this.referral) {
                this.result = 1;
                this.error = "referral";
                this.done = true;
            } else if (this.nametoolong) {
                this.result = 1;
                this.error = "name too long";
                this.done = true;
            }
        }
        if (this.completionTask != null) {
            this.completionTask.run();
        }
    }

    private void checkDone() {
        if (this.done && this.result != -1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Lookup of " + this.name + " ");
        if (this.dclass != 1) {
            stringBuffer.append(DClass.string((int)this.dclass) + " ");
        }
        stringBuffer.append(Type.string((int)this.type) + " isn't done");
        throw new IllegalStateException(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record[] getAnswers() {
        LookupAsynch lookupAsynch = this;
        synchronized (lookupAsynch) {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        this.checkDone();
        return this.answers;
    }

    public Name[] getAliases() {
        this.checkDone();
        if (this.aliases == null) {
            return noAliases;
        }
        return this.aliases.toArray(new Name[this.aliases.size()]);
    }

    public int getResult() {
        this.checkDone();
        return this.result;
    }

    public String getErrorString() {
        this.checkDone();
        if (this.error != null) {
            return this.error;
        }
        switch (this.result) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "unrecoverable error";
            }
            case 2: {
                return "try again";
            }
            case 3: {
                return "host not found";
            }
            case 4: {
                return "type not found";
            }
        }
        throw new IllegalStateException("unknown result");
    }

    static {
        random = new Random();
        noAliases = new Name[0];
        id = 1;
        LookupAsynch.refreshDefault();
    }

    private static final class LookupContinuation {
        private final ResponseProcessor responseProcessor;
        private final Message query;

        public LookupContinuation(ResponseProcessor responseProcessor, Message message) {
            this.responseProcessor = responseProcessor;
            this.query = message;
        }

        public ResponseProcessor getResponseProcessor() {
            return this.responseProcessor;
        }

        public Message getQuery() {
            return this.query;
        }
    }

    private static interface ResponseProcessor {
        public LookupContinuation processResponse(Message var1, Response var2);
    }

    private final class CompositeResponseProcessor
    implements ResponseProcessor {
        private ResponseProcessor responseProcessor;
        private Name current;

        public CompositeResponseProcessor(ResponseProcessor responseProcessor, Name name) {
            this.responseProcessor = responseProcessor;
            this.current = name;
        }

        public LookupContinuation processResponse(Message message, Response response) {
            LookupContinuation lookupContinuation = this.responseProcessor.processResponse(message, response);
            if (lookupContinuation != null) {
                return new LookupContinuation(new CompositeResponseProcessor(lookupContinuation.getResponseProcessor(), this.current), lookupContinuation.getQuery());
            }
            return LookupAsynch.this.lookupContinue(this.current);
        }
    }

    private static final class ProcessingTask
    implements Runnable {
        private ProcessingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                LookupAsynch lookupAsynch;
                Response response;
                Object object = responseQueue;
                synchronized (object) {
                    response = responseQueue.getItem();
                    lookupAsynch = (LookupAsynch)pendingLookups.remove(response.getId());
                }
                if (lookupAsynch == null) continue;
                object = lookupAsynch.processResponse(response);
                LookupAsynch lookupAsynch2 = lookupAsynch;
                synchronized (lookupAsynch2) {
                    if (object == null) {
                        lookupAsynch.completeLookup();
                        lookupAsynch.notify();
                    } else {
                        lookupAsynch.submitQuery((LookupContinuation)object);
                    }
                }
            }
        }
    }
}

