/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class StringUtils {
    private StringUtils() {
    }

    public static String[] split(String text, String pattern) {
        String[] array = text.split(pattern, -1);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            boolean escaped = false;
            if (i > 0 && array[i - 1].endsWith("\\")) {
                int depth;
                for (depth = 1; depth < array[i - 1].length() && array[i - 1].charAt(array[i - 1].length() - 1 - depth) == '\\'; ++depth) {
                }
                boolean bl = escaped = depth % 2 == 1;
            }
            if (!escaped) {
                list.add(array[i]);
                continue;
            }
            String prev = (String)list.remove(list.size() - 1);
            list.add(prev.substring(0, prev.length() - 1) + pattern + array[i]);
        }
        return list.toArray(new String[0]);
    }

    public static String md5(String message) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuffer sb = new StringBuffer();
            byte[] buf = message.getBytes();
            byte[] md5 = md.digest(buf);
            for (int i = 0; i < md5.length; ++i) {
                String tmpStr = "0" + Integer.toHexString(0xFF & md5[i]);
                sb.append(tmpStr.substring(tmpStr.length() - 2));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String capitalizeWords(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        char prevCh = '.';
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (Character.isLetter(ch)) {
                if (!Character.isLetter(prevCh)) {
                    res.append(Character.toUpperCase(ch));
                } else {
                    res.append(Character.toLowerCase(ch));
                }
            } else {
                res.append(ch);
            }
            prevCh = ch;
        }
        return res.toString();
    }
}

