/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.MailetUtil;

public abstract class GenericMailet
implements Mailet,
MailetConfig {
    private MailetConfig config = null;

    public void destroy() {
    }

    public boolean getInitParameter(String name, boolean defaultValue) {
        if (this.config == null) {
            throw new NullPointerException("Mailet configuration must be set before getInitParameter is called.");
        }
        return MailetUtil.getInitParameter(this.config, name, defaultValue);
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public String getInitParameter(String name, String defValue) {
        String res = this.config.getInitParameter(name);
        if (res == null) {
            return defValue;
        }
        return res;
    }

    public Iterator getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public MailetConfig getMailetConfig() {
        return this.config;
    }

    public MailetContext getMailetContext() {
        return this.getMailetConfig().getMailetContext();
    }

    public String getMailetInfo() {
        return "";
    }

    public String getMailetName() {
        return this.config.getMailetName();
    }

    public void init(MailetConfig newConfig) throws MessagingException {
        this.config = newConfig;
        this.init();
    }

    public void init() throws MessagingException {
    }

    public void log(String message) {
        this.getMailetContext().log(message);
    }

    public void log(String message, Throwable t) {
        this.getMailetContext().log(message, t);
    }

    public abstract void service(Mail var1) throws MessagingException;

    protected final void checkInitParameters(String[] allowedArray) throws MessagingException {
        if (allowedArray == null) {
            return;
        }
        HashSet<String> allowed = new HashSet<String>();
        ArrayList<String> bad = new ArrayList<String>();
        for (int i = 0; i < allowedArray.length; ++i) {
            allowed.add(allowedArray[i]);
        }
        Iterator iterator = this.getInitParameterNames();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (allowed.contains(parameter)) continue;
            bad.add(parameter);
        }
        if (bad.size() > 0) {
            throw new MessagingException("Unexpected init parameters found: " + this.arrayToString(bad.toArray()));
        }
    }

    protected final String arrayToString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(1024);
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

