/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.james.jdkim.canon.AbstractOutputStreamTestCase;
import org.apache.james.jdkim.canon.SimpleBodyCanonicalizer;

public class SimpleBodyCanonicalizerTest
extends AbstractOutputStreamTestCase {
    private byte[] testData;
    private byte[] expectedData;

    protected void setUp() throws Exception {
        this.testData = "this  is a \r\n  canonicalization \ttest\r\n\r\n\r\n".getBytes();
        this.expectedData = "this  is a \r\n  canonicalization \ttest\r\n".getBytes();
    }

    public void testSingleBytes() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        for (int i = 0; i < this.testData.length; ++i) {
            os.write((int)this.testData[i]);
        }
        os.close();
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    public void testChunks() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        this.chunker(this.testData, (OutputStream)os);
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    public void testCRLFchunk() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        this.writeChunk((OutputStream)os, this.testData, 0, 37);
        this.writeChunk((OutputStream)os, this.testData, 37, 6);
        os.close();
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    public void testProblematicChunks() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        this.writeChunk((OutputStream)os, this.testData, 0, 38);
        this.writeChunk((OutputStream)os, this.testData, 38, 2);
        this.writeChunk((OutputStream)os, this.testData, 40, 3);
        os.close();
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    protected OutputStream newInstance(ByteArrayOutputStream bos) {
        return new SimpleBodyCanonicalizer((OutputStream)bos);
    }

    public void testExtensiveChunks() throws NoSuchAlgorithmException, IOException {
        this.extensiveChunker(this.testData, this.expectedData);
    }

    public void testWrongCRSequences() throws NoSuchAlgorithmException, IOException {
        byte[] test = "this  is a \r\n  canonica\rlizati".getBytes();
        byte[] expected = "this  is a \r\n  canonica\rlizati\r\n".getBytes();
        this.extensiveChunker(test, expected);
    }

    public void testProblematicCRSequences() throws NoSuchAlgorithmException, IOException {
        byte[] test = "this  is a \r\n  canonica\rlizati".getBytes();
        byte[] expected = "this  is a \r\n  canonica\rlizati\r\n".getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        this.writeChunk((OutputStream)os, test, 0, 24);
        this.writeChunk((OutputStream)os, test, 24, 1);
        this.writeChunk((OutputStream)os, test, 25, 5);
        os.close();
        this.assertArrayEquals(expected, bos.toByteArray());
    }

    public void testWrongCRSequencesAdv() throws NoSuchAlgorithmException, IOException {
        byte[] test = "this  is a \r\n  canonica\rlizati\r\ron\r\n\r\n\r".getBytes();
        byte[] expected = "this  is a \r\n  canonica\rlizati\r\ron\r\n".getBytes();
        this.extensiveChunker(test, expected);
    }

    public void testProblematicEndingCRLFCR() throws NoSuchAlgorithmException, IOException {
        byte[] test = "this  is a \r\n  canonica\rlizati\r\ron\r\n\r\n\r".getBytes();
        byte[] expected = "this  is a \r\n  canonica\rlizati\r\ron\r\n".getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        this.writeChunk((OutputStream)os, test, 0, 39);
        os.close();
        this.assertArrayEquals(expected, bos.toByteArray());
    }

    public void testProblematicEndingCR() throws NoSuchAlgorithmException, IOException {
        byte[] test = "this  is a \r\n  canonica\rlizati\r\ron\r\n\r\n\r".getBytes();
        byte[] expected = "this  is a \r\n  canonica\rlizati\r\ron\r\n".getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleBodyCanonicalizer os = new SimpleBodyCanonicalizer((OutputStream)bos);
        this.writeChunk((OutputStream)os, test, 0, 31);
        this.writeChunk((OutputStream)os, test, 31, 1);
        this.writeChunk((OutputStream)os, test, 32, 7);
        os.close();
        this.assertArrayEquals(expected, bos.toByteArray());
    }
}

