/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import junit.framework.TestCase;
import org.apache.james.jdkim.DKIMSigner;
import org.apache.james.jdkim.DKIMVerifier;
import org.apache.james.jdkim.MockPublicKeyRecordRetriever;
import org.apache.james.jdkim.api.PublicKeyRecord;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;
import org.apache.james.jdkim.impl.DNSPublicKeyRecordRetriever;
import org.apache.james.jdkim.tagvalue.TagValue;

public class DNSPublicKeyRetrieverTest
extends TestCase {
    public void testWrongOption() throws TempFailException {
        try {
            new DNSPublicKeyRecordRetriever().getRecords((CharSequence)"somethingelse", (CharSequence)"test", (CharSequence)"test");
            DNSPublicKeyRetrieverTest.fail((String)"expected unsupported operation");
        }
        catch (PermFailException permFailException) {
            // empty catch block
        }
    }

    public void testConstructor() {
        new DNSPublicKeyRecordRetriever();
    }

    public void testRetrieve() throws TempFailException, PermFailException {
        DNSPublicKeyRecordRetriever pkr = new DNSPublicKeyRecordRetriever();
        pkr.getRecords((CharSequence)"dns/txt", (CharSequence)"lima", (CharSequence)"yahoogroups.com");
        pkr.getRecords((CharSequence)"dns/txt", (CharSequence)"gamma", (CharSequence)"gmail.com");
        new TagValue((String)pkr.getRecords((CharSequence)"dns/txt", (CharSequence)"lima", (CharSequence)"yahoogroups.com").get(0));
    }

    public void testKeyPair() throws PermFailException, TempFailException, NoSuchAlgorithmException, InvalidKeySpecException {
        PublicKeyRecord key = new DKIMVerifier().publicKeySelector(new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", "dummy", "dummy").getRecords("dns/txt", "dummy", "dummy"));
        String privateKeyPKCS8 = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBANgNpgpfPBVjCpZsuGa4nrppMA3zCYNH6t8cTwd+eRI5rHSgihMznOq5mtMujfTzvRgx9jPHB8HqP83PdB3CtQP+3RgxgmJQrJYmcIp9lcckEn7J9Eevuhb5RbdxWj0IbZsF8jGwifBh7XvmD1SPKe0mla56p0QijVzZuG/0ynrpAgMBAAECgYEAjxdzCdmLRKrk3z3AX6AU2GdEQWjeuwkNoJjyKod0DkMOWevdptv/KGKnDQj/UeWALp8gbah7Fc5cVaX5RKCpG3WRO32NeFUUTGDyY2SjZR6UDAW2yXwJGNVxhA5x514f9Yz+ZeODbBSqpl6cGaUqUPq81vvSMUl5VoMn/ufuPwECQQD02QfYPhmCP8g4BVhxxlgfvj5WA7R7tWRSNCT3C0naPpwaono9+PSuhUgxRbOgFvxh8StHyXomdVBt/LzeAl6JAkEA4eTejDsmMCfxe47JnHbgpxNphYpSQBB9FZgMUU5hAXgpX3EtIS3JxjSSOx3EYoO51ZywBOWUXNcMJAXoNM0hYQJAQDnZ4/BOMqtWctN8IsQbg6Acq+Vm53hqa2HAPIlagwQfYKE0HaN7U3gkusAE4T6GT466gqcoAoSNZ3x/cmD+uQJAePyZCaiAephaKSA/8VJmXnXyNXjxNqjeJduq9T0yjZPrLNg0IKoigMsVax41WcJNnRBv4h+IR/VR5lVXmjgn4QJANq02dLdX2phQqOP+Ss1EP9TT7t6HxLbKUuoPdGVKf0q1gZEyAC1Re2I4SLMEfpt3+ivMj1X2zDzIHP5mogfblA==";
        PrivateKey privKey = DKIMSigner.getPrivateKey((String)privateKeyPKCS8);
        DNSPublicKeyRetrieverTest.assertEquals((Object)((RSAKey)((Object)privKey)).getModulus(), (Object)((RSAKey)((Object)key.getPublicKey())).getModulus());
    }

    public void testSignVerify() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, FailException {
        MockPublicKeyRecordRetriever mockPublicKeyRecordRetriever = new MockPublicKeyRecordRetriever("v=DKIM1; k=rsa; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYDaYKXzwVYwqWbLhmuJ66aTAN8wmDR+rfHE8HfnkSOax0oIoTM5zquZrTLo30870YMfYzxwfB6j/Nz3QdwrUD/t0YMYJiUKyWJnCKfZXHJBJ+yfRHr7oW+UW3cVo9CG2bBfIxsInwYe175g9UjyntJpWueqdEIo1c2bhv9Mp66QIDAQAB;", "selector", "example.com");
        PublicKeyRecord key = new DKIMVerifier().publicKeySelector(mockPublicKeyRecordRetriever.getRecords("dns/txt", "selector", "example.com"));
        String privateKeyPKCS8 = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBANgNpgpfPBVjCpZsuGa4nrppMA3zCYNH6t8cTwd+eRI5rHSgihMznOq5mtMujfTzvRgx9jPHB8HqP83PdB3CtQP+3RgxgmJQrJYmcIp9lcckEn7J9Eevuhb5RbdxWj0IbZsF8jGwifBh7XvmD1SPKe0mla56p0QijVzZuG/0ynrpAgMBAAECgYEAjxdzCdmLRKrk3z3AX6AU2GdEQWjeuwkNoJjyKod0DkMOWevdptv/KGKnDQj/UeWALp8gbah7Fc5cVaX5RKCpG3WRO32NeFUUTGDyY2SjZR6UDAW2yXwJGNVxhA5x514f9Yz+ZeODbBSqpl6cGaUqUPq81vvSMUl5VoMn/ufuPwECQQD02QfYPhmCP8g4BVhxxlgfvj5WA7R7tWRSNCT3C0naPpwaono9+PSuhUgxRbOgFvxh8StHyXomdVBt/LzeAl6JAkEA4eTejDsmMCfxe47JnHbgpxNphYpSQBB9FZgMUU5hAXgpX3EtIS3JxjSSOx3EYoO51ZywBOWUXNcMJAXoNM0hYQJAQDnZ4/BOMqtWctN8IsQbg6Acq+Vm53hqa2HAPIlagwQfYKE0HaN7U3gkusAE4T6GT466gqcoAoSNZ3x/cmD+uQJAePyZCaiAephaKSA/8VJmXnXyNXjxNqjeJduq9T0yjZPrLNg0IKoigMsVax41WcJNnRBv4h+IR/VR5lVXmjgn4QJANq02dLdX2phQqOP+Ss1EP9TT7t6HxLbKUuoPdGVKf0q1gZEyAC1Re2I4SLMEfpt3+ivMj1X2zDzIHP5mogfblA==";
        PrivateKey privKey = DKIMSigner.getPrivateKey((String)privateKeyPKCS8);
        DNSPublicKeyRetrieverTest.assertEquals((Object)((RSAKey)((Object)privKey)).getModulus(), (Object)((RSAKey)((Object)key.getPublicKey())).getModulus());
        DKIMSigner signer = new DKIMSigner("v=1; s=selector; d=example.com; h=from:to; a=rsa-sha256; bh=; b=;", privKey);
        String message = "From: test@example.com\r\nTo: test@example.com\r\n\r\nbody\r\n";
        String res = signer.sign((InputStream)new ByteArrayInputStream(message.getBytes()));
        String signedMessage = res + "\r\n" + "From: test@example.com\r\nTo: test@example.com\r\n\r\nbody\r\n";
        new DKIMVerifier((PublicKeyRecordRetriever)mockPublicKeyRecordRetriever).verify((InputStream)new ByteArrayInputStream(signedMessage.getBytes()));
    }
}

