/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.jdkim.api.Headers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MimeMessageHeaders
implements Headers {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private List<String> fields = new LinkedList<String>();

    public MimeMessageHeaders(MimeMessage message) throws MessagingException {
        Enumeration e = message.getAllHeaderLines();
        while (e.hasMoreElements()) {
            String head = (String)e.nextElement();
            int p = head.indexOf(58);
            if (p <= 0) {
                throw new MessagingException("Bad header line: " + head);
            }
            String headerName = head.substring(0, p).trim();
            String headerNameLC = headerName.toLowerCase();
            this.fields.add(headerName);
            List<String> strings = this.headers.get(headerNameLC);
            if (strings == null) {
                strings = new LinkedList<String>();
                this.headers.put(headerNameLC, strings);
            }
            strings.add(head);
        }
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getFields(String name) {
        return this.headers.get(name.toLowerCase());
    }
}

