/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.james.jdkim.tagvalue.PublicKeyRecordImpl;

public class PublicKeyRecordTest
extends TestCase {
    public void testValidate() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("");
        try {
            pkr.validate();
            PublicKeyRecordTest.fail((String)"Expected failure: missing mandatory parameters");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        pkr = new PublicKeyRecordImpl("v=DKIM1; k=rsa; p=XXXXXX=");
        pkr.validate();
        pkr = new PublicKeyRecordImpl(" v=DKIM1; k=rsa; p=XXXXXX=");
        pkr.validate();
        pkr = new PublicKeyRecordImpl("k=rsa; v=DKIM1; p=XXXXXX=");
        try {
            pkr.validate();
            PublicKeyRecordTest.fail((String)"Expected failure: v should be the first");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        pkr = new PublicKeyRecordImpl("v=DKIM2; k=rsa; p=XXXXXX=");
        try {
            pkr.validate();
            PublicKeyRecordTest.fail((String)"Expected failure: wrong version");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        pkr = new PublicKeyRecordImpl("v=DKIM1; k=rsa; p=");
        try {
            pkr.validate();
            PublicKeyRecordTest.fail((String)"Expected failure: revoked key");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIsHashMethodSupported() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        PublicKeyRecordTest.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha1"));
        PublicKeyRecordTest.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha256"));
        pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        PublicKeyRecordTest.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha1"));
        PublicKeyRecordTest.assertFalse((boolean)pkr.isHashMethodSupported((CharSequence)"sha128"));
        PublicKeyRecordTest.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha256"));
    }

    public void testIsKeyTypeSupported() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        PublicKeyRecordTest.assertTrue((boolean)pkr.isKeyTypeSupported((CharSequence)"rsa"));
        PublicKeyRecordTest.assertFalse((boolean)pkr.isKeyTypeSupported((CharSequence)"dsa"));
    }

    public void testGetAcceptableHashMethods() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        List methods = pkr.getAcceptableHashMethods();
        PublicKeyRecordTest.assertEquals((String)"[sha1, sha256]", (String)methods.toString());
        pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        methods = pkr.getAcceptableHashMethods();
        PublicKeyRecordTest.assertNull((Object)methods);
    }

    public void testGetAcceptableKeyTypes() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        List methods = pkr.getAcceptableKeyTypes();
        PublicKeyRecordTest.assertEquals((String)"[rsa]", (String)methods.toString());
        pkr = new PublicKeyRecordImpl("k=rsa:dsa; p=XXXXXXXX=;");
        pkr.validate();
        methods = pkr.getAcceptableKeyTypes();
        PublicKeyRecordTest.assertEquals((String)"[rsa, dsa]", (String)methods.toString());
    }

    public void testGetGranularityPattern() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        Pattern pattern = pkr.getGranularityPattern();
        PublicKeyRecordTest.assertEquals((String)"^\\Q\\E.*\\Q\\E$", (String)pattern.pattern());
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("something").matches());
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("").matches());
        pkr = new PublicKeyRecordImpl("k=rsa; g=; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        PublicKeyRecordTest.assertEquals((String)"@", (String)pattern.pattern());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("something").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("").matches());
        pkr = new PublicKeyRecordImpl("k=rsa; g=some*; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("something").matches());
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("some").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("som").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("awesome").matches());
        PublicKeyRecordTest.assertEquals((String)"^\\Qsome\\E.*\\Q\\E$", (String)pattern.pattern());
        pkr = new PublicKeyRecordImpl("k=rsa; g=*+test; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        PublicKeyRecordTest.assertEquals((String)"^\\Q\\E.*\\Q+test\\E$", (String)pattern.pattern());
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("a+test").matches());
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("+test").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("atest").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("+tested").matches());
        pkr = new PublicKeyRecordImpl("k=rsa; g=test; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        PublicKeyRecordTest.assertEquals((String)"^\\Qtest\\E$", (String)pattern.pattern());
        PublicKeyRecordTest.assertTrue((boolean)pattern.matcher("test").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("atest").matches());
        PublicKeyRecordTest.assertFalse((boolean)pattern.matcher("testa").matches());
        try {
            pkr = new PublicKeyRecordImpl("k=rsa; g=*\\+test; h=sha1:sha256; p=XXXXXXXX=;");
            pkr.validate();
            pattern = pkr.getGranularityPattern();
            PublicKeyRecordTest.fail((String)"Expected syntax error");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            pkr = new PublicKeyRecordImpl("k=rsa; g=*test*; h=sha1:sha256; p=XXXXXXXX=;");
            pkr.validate();
            pattern = pkr.getGranularityPattern();
            PublicKeyRecordTest.fail((String)"Expected syntax error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetPublicKey() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKey pk = pkr.getPublicKey();
        PublicKeyRecordTest.assertEquals((String)"RSA", (String)pk.getAlgorithm());
        PublicKeyRecordTest.assertEquals((Object)new BigInteger("140815480285950232210124449496973988135931539914762288985377502488754711434253259186192434865594456027796377309280714060984552676169392598862819043219650259702261370701494928576447797673342985377518637829874968725582762257956980427968667812066816497848410406856165942400151628259779523949079651036806330485849"), (Object)((RSAKey)((Object)pk)).getModulus());
        try {
            pkr = new PublicKeyRecordImpl("k=dsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
            pkr.validate();
            pk = pkr.getPublicKey();
            PublicKeyRecordTest.fail((String)"Expected invalid key spec. DSA is not supported");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            pkr = new PublicKeyRecordImpl("k=unknown; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
            pkr.validate();
            pk = pkr.getPublicKey();
            PublicKeyRecordTest.fail((String)"Expected invalid algorythm. 'unknown' is not supported");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetFlags() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y:s; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        List flags = pkr.getFlags();
        PublicKeyRecordTest.assertEquals((String)"[y, s]", (String)flags.toString());
        pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        flags = pkr.getFlags();
        PublicKeyRecordTest.assertEquals((String)"[y]", (String)flags.toString());
        pkr = new PublicKeyRecordImpl("k=rsa; t=; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        flags = pkr.getFlags();
        PublicKeyRecordTest.assertEquals((String)"[]", (String)flags.toString());
    }

    public void testIsTesting() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y:s; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKeyRecordTest.assertTrue((boolean)pkr.isTesting());
        pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKeyRecordTest.assertTrue((boolean)pkr.isTesting());
        pkr = new PublicKeyRecordImpl("k=rsa; t=; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKeyRecordTest.assertFalse((boolean)pkr.isTesting());
    }

    public void testIsDenySubdomains() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y:s; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKeyRecordTest.assertTrue((boolean)pkr.isDenySubdomains());
        pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKeyRecordTest.assertFalse((boolean)pkr.isDenySubdomains());
        pkr = new PublicKeyRecordImpl("k=rsa; t=; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKeyRecordTest.assertFalse((boolean)pkr.isDenySubdomains());
    }
}

