/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;
import org.apache.james.jdkim.impl.MultiplexingPublicKeyRecordRetriever;

public class MultiplexingPublicKeyRecordRetrieverTest
extends TestCase {
    private PublicKeyRecordRetriever myMethodRetriever = new PublicKeyRecordRetriever(){

        public List<String> getRecords(CharSequence methodAndOption, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
            ArrayList<String> l = new ArrayList<String>();
            l.add(((Object)selector).toString());
            l.add(((Object)token).toString());
            return l;
        }
    };

    public void testMultiplexingPublicKeyRecordRetriever() {
        MultiplexingPublicKeyRecordRetriever pkrr = new MultiplexingPublicKeyRecordRetriever();
        try {
            pkrr.getRecords((CharSequence)"method", (CharSequence)"selector", (CharSequence)"token");
            MultiplexingPublicKeyRecordRetrieverTest.fail((String)"method is unknown");
        }
        catch (FailException failException) {
            // empty catch block
        }
    }

    public void testMultiplexingPublicKeyRecordRetrieverStringPublicKeyRecordRetriever() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever pkrr = new MultiplexingPublicKeyRecordRetriever("mymethod", this.myMethodRetriever);
        this.check(pkrr, "mymethod");
    }

    private void check(MultiplexingPublicKeyRecordRetriever pkrr, String method) throws TempFailException, PermFailException {
        List l = pkrr.getRecords((CharSequence)method, (CharSequence)"selector", (CharSequence)"token");
        Iterator i = l.iterator();
        MultiplexingPublicKeyRecordRetrieverTest.assertEquals((String)"selector", (String)((String)i.next()));
        MultiplexingPublicKeyRecordRetrieverTest.assertEquals((String)"token", (String)((String)i.next()));
        try {
            l = pkrr.getRecords((CharSequence)"anothermethod", (CharSequence)"selector", (CharSequence)"token");
            MultiplexingPublicKeyRecordRetrieverTest.fail((String)"anothermethod is not declared");
        }
        catch (FailException e) {
            // empty catch block
        }
    }

    public void testAddRetriever() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever pkrr = new MultiplexingPublicKeyRecordRetriever();
        pkrr.addRetriever("mymethod", this.myMethodRetriever);
        this.check(pkrr, "mymethod");
    }

    public void testAddRetrieverWithOptions() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever pkrr = new MultiplexingPublicKeyRecordRetriever();
        pkrr.addRetriever("mymethod", this.myMethodRetriever);
        this.check(pkrr, "mymethod/option");
    }
}

