/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.hupa.client;

import org.apache.hupa.widgets.WidgetsCSS;


/**
 * CSS class names used in Hupa
 */
public class HupaCSS extends WidgetsCSS {
    
    public static final String C_app_container ="Hupa";

    public static final String C_logo_container ="hupa-logo";
    
    public static final String C_button_container ="hupa-button-bar";
    public static final String C_login_info_container = "hupa-loginfo";
    public static final String C_login_info_label = "hupa-loginfo-label";
    public static final String C_login_info_user = "hupa-loginfo-user";
    public static final String C_menu_button = "hupa-menu-button";
    
    public static final String C_info_container ="hupa-info-bar";
    public static final String C_header ="hupa-header";
    public static final String C_flash ="hupa-flash";

    public static final String C_top_container ="hupa-top";
    public static final String C_main_container ="hupa-main";
    public static final String C_bottom_container ="hupa-bottom";
    
    public static final String C_login_container = "hupa-login";
    public static final String C_login_form = "hupa-login-form";
    public static final String C_login_box = "hupa-login-textbox";
    
    public static final String C_contacts_container = "hupa-contacts";

    public static final String C_tree_container = "hupa-tree";

    public static final String C_msg_list_container = "hupa-msglist";
    public static final String C_msg_table = "hupa-msgtable";
    public static final String C_msg_table_empty = "hupa-msgtable-empty";
    public static final String C_msg_table_row = "hupa-msgtable-row";
    public static final String C_msg_table_seen = "hupa-msgtable-seen";
    public static final String C_msg_table_unseen = "hupa-msgtable-unseen";
    public static final String C_msg_search = "hupa-search-box";

    public static final String C_msg_top_bar = "hupa-msg-top-bar";
    
    public static final String C_commands_bar = "hupa-commands-bar";
    
    public static final String C_msgview_container = "hupa-msgview";
    public static final String C_msgview_content = "hupa-msgview-content";

    public static final String C_msgsend_container = "hupa-msgsend";
    
    public static final String C_buttons = "hupa-buttons";

    public static final String C_msg_headers = "hupa-msg-headers";

    public static final String C_dialog = "hupa-dialog-box";
    
    public static final String C_validate = "hupa-validate-error";
    
    public static final String C_button = "hupa-button";
}
